/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.mguimard.openrgb.client;

import io.gitlab.mguimard.openrgb.client.OpenRGBCommand;
import io.gitlab.mguimard.openrgb.entity.OpenRGBColor;
import io.gitlab.mguimard.openrgb.entity.OpenRGBDevice;
import io.gitlab.mguimard.openrgb.entity.OpenRGBMode;
import io.gitlab.mguimard.openrgb.utils.DeviceParser;
import io.gitlab.mguimard.openrgb.utils.LittleEndianInputStream;
import io.gitlab.mguimard.openrgb.utils.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpenRGBClient {
    private final ReentrantLock socketLock = new ReentrantLock();
    private static final Logger LOGGER = Logger.getLogger(OpenRGBClient.class.getName());
    private static final int HEADER_SIZE = 16;
    private static final byte[] MAGIC_STRING = "ORGB".getBytes(StandardCharsets.US_ASCII);
    private final String host;
    private final int port;
    private final String name;
    private OutputStream out;
    private InputStream in;
    private Socket socket;
    private int serverProtocol;

    public OpenRGBClient(String host, int port, String name) {
        this.host = host;
        this.port = port;
        this.name = name;
    }

    public void connect() throws IOException {
        this.disconnect();
        this.socket = new Socket();
        this.socket.connect(new InetSocketAddress(this.host, this.port));
        this.out = new BufferedOutputStream(this.socket.getOutputStream());
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.setClientName();
        this.serverProtocol = this.getProtocolVersion();
    }

    public void disconnect() throws IOException {
        if (null != this.socket && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public void setClientName() throws IOException {
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.SetClientName, (this.name + '\u0000').getBytes(StandardCharsets.US_ASCII));
        }
        finally {
            this.socketLock.unlock();
        }
    }

    public int getControllerCount() throws IOException {
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.RequestControllerCount);
            int n = this.read().getInt();
            return n;
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenRGBDevice getDeviceController(int deviceIndex) throws IOException {
        this.socketLock.lock();
        try {
            byte[] data = Utils.byteArrayFromInt(this.serverProtocol);
            this.sendMessage(OpenRGBCommand.RequestControllerData, deviceIndex, data);
            OpenRGBDevice openRGBDevice = DeviceParser.from(this.read(), this.serverProtocol);
            return openRGBDevice;
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLed(int deviceIndex, int ledIndex, OpenRGBColor color) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt(ledIndex).put(color.getRed()).put(color.getGreen()).put(color.getBlue());
        data.position(data.position() + 1);
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.UpdateSingleLed, deviceIndex, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeds(int deviceIndex, OpenRGBColor[] colors) throws IOException {
        ByteBuffer data = (ByteBuffer)ByteBuffer.allocate(6 + 4 * colors.length).order(ByteOrder.LITTLE_ENDIAN).position(4);
        data.putShort((short)colors.length);
        for (OpenRGBColor color : colors) {
            data.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).position(data.position() + 1);
        }
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.UpdateLeds, deviceIndex, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateZoneLeds(int deviceIndex, int zoneIndex, OpenRGBColor[] colors) throws IOException {
        ByteBuffer data = (ByteBuffer)ByteBuffer.allocate(10 + 4 * colors.length).order(ByteOrder.LITTLE_ENDIAN).position(4);
        data.putInt(zoneIndex);
        data.putShort((short)colors.length);
        for (OpenRGBColor color : colors) {
            data.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).position(data.position() + 1);
        }
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.UpdateZoneLeds, deviceIndex, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMode(int deviceIndex, int modeIndex, OpenRGBMode mode) throws IOException {
        List<OpenRGBColor> colors = mode.getColors();
        byte[] nameBytes = mode.getName().getBytes(StandardCharsets.US_ASCII);
        ByteBuffer data = ByteBuffer.allocate(10 + nameBytes.length + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 4 + 2 + 4 * colors.size()).order(ByteOrder.LITTLE_ENDIAN);
        data.position(4);
        data.putInt(modeIndex).putShort((short)nameBytes.length).put(nameBytes).putInt(mode.getValue()).putInt(mode.getFlags()).putInt(mode.getSpeedMin()).putInt(mode.getSpeedMax()).putInt(mode.getColorMin()).putInt(mode.getColorMax()).putInt(mode.getSpeed()).putInt(mode.getDirection().ordinal()).putInt(mode.getColorMode().ordinal()).putShort((short)colors.size());
        for (OpenRGBColor color : colors) {
            data.put(color.getRed()).put(color.getGreen()).put(color.getBlue()).position(data.position() + 1);
        }
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.UpdateMode, deviceIndex, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeZone(int deviceIndex, int zoneIndex, int size) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putInt(zoneIndex).putInt(size);
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.ResizeZone, deviceIndex, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getProfileList() throws IOException {
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.RequestProfileList);
            LittleEndianInputStream stream = new LittleEndianInputStream(new ByteArrayInputStream(this.read().array()));
            stream.skip(4L);
            int profilesCount = stream.readUnsignedShort();
            String[] profiles = new String[profilesCount];
            for (int i = 0; i < profilesCount; ++i) {
                profiles[i] = stream.readAscii();
            }
            String[] stringArray = profiles;
            return stringArray;
        }
        finally {
            this.socketLock.unlock();
        }
    }

    public void saveProfile(String profileName) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(profileName.length()).order(ByteOrder.LITTLE_ENDIAN).put(profileName.getBytes(StandardCharsets.US_ASCII));
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.SaveProfile, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    public void loadProfile(String profileName) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(profileName.length()).order(ByteOrder.LITTLE_ENDIAN).put(profileName.getBytes(StandardCharsets.US_ASCII));
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.LoadProfile, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    public void deleteProfile(String profileName) throws IOException {
        ByteBuffer data = ByteBuffer.allocate(profileName.length()).order(ByteOrder.LITTLE_ENDIAN).put(profileName.getBytes(StandardCharsets.US_ASCII));
        this.socketLock.lock();
        try {
            this.sendMessage(OpenRGBCommand.DeleteProfile, data.array());
        }
        finally {
            this.socketLock.unlock();
        }
    }

    private int getProtocolVersion() throws IOException {
        byte[] data = Utils.byteArrayFromInt(this.serverProtocol);
        this.sendMessage(OpenRGBCommand.GetProtocolVersion, data);
        return this.read().getInt();
    }

    private byte[] createMagicHeader(int deviceIndex, OpenRGBCommand openRGBCommand, int length) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).put(MAGIC_STRING).putInt(deviceIndex).putInt(openRGBCommand.getValue()).putInt(length);
        return byteBuffer.array();
    }

    private void sendMessage(OpenRGBCommand command) throws IOException {
        this.sendMessage(command, 0, null);
    }

    private void sendMessage(OpenRGBCommand command, int deviceIndex) throws IOException {
        this.sendMessage(command, deviceIndex, null);
    }

    private void sendMessage(OpenRGBCommand command, byte[] data) throws IOException {
        this.sendMessage(command, 0, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(OpenRGBCommand command, int deviceIndex, byte[] data) throws IOException {
        byte[] header = this.createMagicHeader(deviceIndex, command, null != data ? data.length : 0);
        this.socketLock.lock();
        try {
            this.out.write(header);
            if (null != data && data.length > 0) {
                this.out.write(data);
            }
            this.out.flush();
        }
        finally {
            this.socketLock.unlock();
        }
        LOGGER.log(Level.FINEST, "CLIENT: <" + Utils.bytesToHex(header) + " ---- " + (null != data ? Utils.bytesToHex(data) : "") + ">");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer read() throws IOException {
        byte[] header = new byte[16];
        this.in.read(header, 0, 16);
        ByteBuffer byteBuffer = ByteBuffer.wrap(header).order(ByteOrder.LITTLE_ENDIAN);
        int length = byteBuffer.getInt(12);
        this.socketLock.lock();
        try {
            byte[] data = Utils.readFully(this.in, length);
            LOGGER.log(Level.FINEST, "SERVER: <" + Utils.bytesToHex(header) + " ---- " + Utils.bytesToHex(data) + ">");
            ByteBuffer byteBuffer2 = ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN);
            return byteBuffer2;
        }
        finally {
            this.socketLock.unlock();
        }
    }
}

