/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.mguimard.openrgb.utils;

import io.gitlab.mguimard.openrgb.entity.OpenRGBColor;
import java.util.ArrayList;
import java.util.Collections;

public class ColorUtils {
    public static OpenRGBColor[] generateRainbow(int size, int startH, double startS, double startV, int endH, double endS, double endV, int waves) {
        boolean reverse;
        if (size <= 0) {
            return new OpenRGBColor[0];
        }
        startH = Math.abs(startH);
        startH = Math.min(startH, 360);
        startS = Math.abs(startS);
        startS = Math.min(startS, 1.0);
        startV = Math.abs(startV);
        startV = Math.min(startV, 1.0);
        endH = Math.abs(endH);
        endH = Math.min(endH, 360);
        endS = Math.abs(endS);
        endS = Math.min(endS, 1.0);
        endV = Math.abs(endV);
        endV = Math.min(endV, 1.0);
        waves = Math.abs(waves);
        waves = Math.max(1, waves);
        boolean bl = reverse = startH > endH;
        if (startH > endH) {
            int tmp = startH;
            startH = endH;
            endH = tmp;
        }
        double stepH = (double)(endH - startH) / ((double)(size / waves) * 1.0);
        double stepS = (endS - startS) / ((double)(size / waves) * 1.0);
        double stepV = (endV - startV) / ((double)(size / waves) * 1.0);
        ArrayList colors = new ArrayList();
        ArrayList<OpenRGBColor> waveColors = new ArrayList<OpenRGBColor>();
        int i = 0;
        while ((double)i < 1.0 * (double)size / (double)waves) {
            float hue = (float)((double)startH + stepH * (double)i);
            float saturation = (float)(startS + stepS * (double)i);
            float value = (float)(startV + stepV * (double)i);
            waveColors.add(OpenRGBColor.fromHSB(hue, saturation, value));
            ++i;
        }
        if (reverse) {
            Collections.reverse(waveColors);
        }
        ArrayList reversedWaveColors = new ArrayList(waveColors);
        Collections.reverse(reversedWaveColors);
        for (int wave = 0; wave < waves; ++wave) {
            colors.addAll(wave % 2 == 0 ? waveColors : reversedWaveColors);
        }
        return colors.toArray(new OpenRGBColor[size]);
    }
}

