/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.mguimard.openrgb.entity;

public class OpenRGBColor {
    private byte red;
    private byte green;
    private byte blue;

    public OpenRGBColor(int red, int green, int blue) {
        this.red = (byte)red;
        this.green = (byte)green;
        this.blue = (byte)blue;
    }

    public static OpenRGBColor fromInt(int value) {
        return new OpenRGBColor(value >> 16 & 0xFF, value >> 8 & 0xFF, value & 0xFF);
    }

    public static OpenRGBColor fromHSB(float hue, float saturation, float brightness) {
        hue /= 360.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return OpenRGBColor.fromInt(0xFF000000 | r << 16 | g << 8 | b << 0);
    }

    public static OpenRGBColor fromHexaString(String value) {
        try {
            return OpenRGBColor.fromInt(Integer.decode(value));
        }
        catch (Exception e) {
            return new OpenRGBColor(255, 255, 255);
        }
    }

    public int getIntValue() {
        return (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF | 0xFF000000;
    }

    public String getHexaString() {
        return String.format("#%02X%02X%02X", this.red, this.green, this.blue);
    }

    public byte getRed() {
        return this.red;
    }

    public void setRed(byte red) {
        this.red = red;
    }

    public byte getGreen() {
        return this.green;
    }

    public void setGreen(byte green) {
        this.green = green;
    }

    public byte getBlue() {
        return this.blue;
    }

    public void setBlue(byte blue) {
        this.blue = blue;
    }

    public String toString() {
        return "OpenRGBColor{" + this.getHexaString() + '}';
    }
}

