package io.gitlab.mguimard.openrgb.examples;

import io.gitlab.mguimard.openrgb.client.OpenRGBClient;
import io.gitlab.mguimard.openrgb.entity.OpenRGBColor;
import io.gitlab.mguimard.openrgb.entity.OpenRGBDevice;

import java.io.IOException;
import java.util.Arrays;

public class SetColor {

    public static void main(String[] args) {
        OpenRGBClient client = new OpenRGBClient("localhost", 6742, "foo");

        try {
            client.connect();
            OpenRGBDevice controller = client.getDeviceController(0);
            System.out.println(controller.getName());

            OpenRGBColor[] openRGBColors = new OpenRGBColor[controller.getColors().size()];
            Arrays.fill(openRGBColors, new OpenRGBColor(0x00,0xFF,0x00));
            client.updateLeds(0, openRGBColors);

        } catch (IOException e) {
            e.printStackTrace();
        }
    }

}
