package io.gitlab.mguimard.openrgb.entity;

import java.util.Arrays;

public class OpenRGBZone {
    private String name;
    private int type;
    private int ledsMin;
    private int ledsMax;
    private int ledsCount;
    private int matrixHeight;
    private int matrixWidth;
    private int[][] matrix;

    /**
     * Returns an instance of an OpenRGBZone
     *
     * @param name zone name
     * @param type zone type
     * @param ledsMin minimum leds
     * @param ledsMax maximum leds
     * @param ledsCount leds count
     * @param matrixHeight height of the matrix
     * @param matrixWidth width of the matrix
     * @param matrix the matrix
     */
    public OpenRGBZone(String name, int type, int ledsMin, int ledsMax, int ledsCount, int matrixHeight, int matrixWidth, int[][] matrix) {
        this.name = name;
        this.type = type;
        this.ledsMin = ledsMin;
        this.ledsMax = ledsMax;
        this.ledsCount = ledsCount;
        this.matrixHeight = matrixHeight;
        this.matrixWidth = matrixWidth;
        this.matrix = matrix;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getLedsMin() {
        return ledsMin;
    }

    public void setLedsMin(int ledsMin) {
        this.ledsMin = ledsMin;
    }

    public int getLedsMax() {
        return ledsMax;
    }

    public void setLedsMax(int ledsMax) {
        this.ledsMax = ledsMax;
    }

    public int getLedsCount() {
        return ledsCount;
    }

    public void setLedsCount(int ledsCount) {
        this.ledsCount = ledsCount;
    }

    @Override
    public String toString() {
        return "OpenRGBZone{" +
                "name='" + name + '\'' +
                ", type=" + type +
                ", ledsMin=" + ledsMin +
                ", ledsMax=" + ledsMax +
                ", ledsCount=" + ledsCount +
                ", matrixHeight=" + matrixHeight +
                ", matrixWidth=" + matrixWidth +
                ", matrix=" + Arrays.toString(matrix) +
                '}';
    }
}
