package io.gitlab.mguimard.openrgb.entity;

import java.util.List;

public class OpenRGBDevice {

    private int type;
    private String name;
    private String vendor;
    private String desc;
    private String version;
    private String serial;
    private String location;
    private int activeMode;
    private List<OpenRGBLed> leds;
    private List<OpenRGBColor> colors;
    private List<OpenRGBMode> modes;
    private List<OpenRGBZone> zones;

    /**
     *
     */
    public OpenRGBDevice() {
    }

    /**
     * @param type
     * @param name
     * @param vendor
     * @param desc
     * @param version
     * @param serial
     * @param location
     * @param activeMode
     * @param leds
     * @param colors
     * @param modes
     * @param zones
     */
    public OpenRGBDevice(int type, String name, String vendor, String desc, String version, String serial, String location, int activeMode, List<OpenRGBLed> leds, List<OpenRGBColor> colors, List<OpenRGBMode> modes, List<OpenRGBZone> zones) {
        this.type = type;
        this.name = name;
        this.vendor = vendor;
        this.desc = desc;
        this.version = version;
        this.serial = serial;
        this.location = location;
        this.activeMode = activeMode;
        this.leds = leds;
        this.colors = colors;
        this.modes = modes;
        this.zones = zones;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVendor() {
        return vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSerial() {
        return serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getActiveMode() {
        return activeMode;
    }

    public void setActiveMode(int activeMode) {
        this.activeMode = activeMode;
    }

    public List<OpenRGBLed> getLeds() {
        return leds;
    }

    public void setLeds(List<OpenRGBLed> leds) {
        this.leds = leds;
    }

    public List<OpenRGBColor> getColors() {
        return colors;
    }

    public void setColors(List<OpenRGBColor> colors) {
        this.colors = colors;
    }

    public List<OpenRGBMode> getModes() {
        return modes;
    }

    public void setModes(List<OpenRGBMode> modes) {
        this.modes = modes;
    }

    public List<OpenRGBZone> getZones() {
        return zones;
    }

    public void setZones(List<OpenRGBZone> zones) {
        this.zones = zones;
    }

    @Override
    public String toString() {
        return "OpenRGBDevice{" +
                "type=" + type +
                ", name='" + name + '\'' +
                ", vendor='" + vendor + '\'' +
                ", desc='" + desc + '\'' +
                ", version='" + version + '\'' +
                ", serial='" + serial + '\'' +
                ", location='" + location + '\'' +
                ", activeMode=" + activeMode +
                ", leds=" + leds +
                ", colors=" + colors +
                ", modes=" + modes +
                ", zones=" + zones +
                '}';
    }
}
