/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.trial;

import com.littlesaints.protean.functions.trial.AbstractTrial;
import com.littlesaints.protean.functions.trial.Strategy;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Trial<T>
extends AbstractTrial<T>
implements Supplier<T> {
    private static final Logger log = LogManager.getLogger(Trial.class);
    private final Supplier<T> supplier;

    public static <T> Trial<T> ofNullable(Strategy strategy, Supplier<T> op) {
        return Trial.of(strategy, op, Objects::nonNull, t -> null);
    }

    public static <T> Trial<Optional<T>> ofOptional(Strategy strategy, Supplier<T> op) {
        return Trial.of(strategy, () -> Optional.ofNullable(op.get()), Optional::isPresent, t -> Optional.empty());
    }

    public static <T> Trial<T> of(Strategy strategy, Supplier<T> op, Predicate<T> successfulOpTest, UnaryOperator<T> onTrialsExhaustion) {
        return new Trial<T>(strategy, op, successfulOpTest, onTrialsExhaustion);
    }

    private Trial(Strategy strategy, Supplier<T> op, Predicate<T> successfulOpTest, UnaryOperator<T> onTrialsExhaustion) {
        super(strategy, successfulOpTest, onTrialsExhaustion);
        this.supplier = op;
    }

    @Override
    public T get() {
        return this.get(this.supplier);
    }
}

