/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.trial;

import java.util.function.IntFunction;
import java.util.function.Supplier;

public class Strategy {
    public static Supplier<Strategy> DEFAULT = Strategy::new;
    public static IntFunction<Strategy> CONSTANT_DELAY_UNBOUNDED_TRIES = delayInMillis -> Strategy.builder().delayBetweenTriesInMillis(delayInMillis).maxTriesWithDelay(-1).delayIncreaseMultiplier(1).build();
    private int maxTriesWithYield;
    private int maxTriesWithDelay;
    private long delayBetweenTriesInMillis;
    private long delayThresholdInMillis;
    private int triesUntilDelayIncrease;
    private int delayIncreaseMultiplier;

    public void validate() {
        if (this.maxTriesWithYield < 0) {
            throw new IllegalArgumentException("maxTriesWithYield must be >= 0 !!");
        }
        if (this.maxTriesWithDelay < 1 && this.maxTriesWithDelay != -1) {
            throw new IllegalArgumentException("maxTriesWithDelay must be >= 1 !!");
        }
        if (this.delayBetweenTriesInMillis < 0L) {
            throw new IllegalArgumentException("delayBetweenTriesInMillis must be >= 0 !!");
        }
        if (this.delayThresholdInMillis < 0L) {
            throw new IllegalArgumentException("delayThresholdInMillis must be >= 0 !!");
        }
        if (this.delayBetweenTriesInMillis > this.delayThresholdInMillis) {
            throw new IllegalArgumentException("delayBetweenTriesInMillis must be <= delayThresholdInMillis !!");
        }
        if (this.triesUntilDelayIncrease < 1 && this.triesUntilDelayIncrease != -1) {
            throw new IllegalArgumentException("triesUntilDelayIncrease must be >= 1 !!");
        }
        if (this.delayIncreaseMultiplier < 1) {
            throw new IllegalArgumentException("delayIncreaseMultiplier must be >= 1 !!");
        }
    }

    private static int $default$maxTriesWithYield() {
        return 0;
    }

    private static int $default$maxTriesWithDelay() {
        return -1;
    }

    private static long $default$delayBetweenTriesInMillis() {
        return 1000L;
    }

    private static long $default$delayThresholdInMillis() {
        return 1800000L;
    }

    private static int $default$triesUntilDelayIncrease() {
        return 5;
    }

    private static int $default$delayIncreaseMultiplier() {
        return 2;
    }

    public static StrategyBuilder builder() {
        return new StrategyBuilder();
    }

    public StrategyBuilder toBuilder() {
        return new StrategyBuilder().maxTriesWithYield(this.maxTriesWithYield).maxTriesWithDelay(this.maxTriesWithDelay).delayBetweenTriesInMillis(this.delayBetweenTriesInMillis).delayThresholdInMillis(this.delayThresholdInMillis).triesUntilDelayIncrease(this.triesUntilDelayIncrease).delayIncreaseMultiplier(this.delayIncreaseMultiplier);
    }

    public int getMaxTriesWithYield() {
        return this.maxTriesWithYield;
    }

    public int getMaxTriesWithDelay() {
        return this.maxTriesWithDelay;
    }

    public long getDelayBetweenTriesInMillis() {
        return this.delayBetweenTriesInMillis;
    }

    public long getDelayThresholdInMillis() {
        return this.delayThresholdInMillis;
    }

    public int getTriesUntilDelayIncrease() {
        return this.triesUntilDelayIncrease;
    }

    public int getDelayIncreaseMultiplier() {
        return this.delayIncreaseMultiplier;
    }

    public String toString() {
        return "Strategy(maxTriesWithYield=" + this.getMaxTriesWithYield() + ", maxTriesWithDelay=" + this.getMaxTriesWithDelay() + ", delayBetweenTriesInMillis=" + this.getDelayBetweenTriesInMillis() + ", delayThresholdInMillis=" + this.getDelayThresholdInMillis() + ", triesUntilDelayIncrease=" + this.getTriesUntilDelayIncrease() + ", delayIncreaseMultiplier=" + this.getDelayIncreaseMultiplier() + ")";
    }

    public Strategy(int maxTriesWithYield, int maxTriesWithDelay, long delayBetweenTriesInMillis, long delayThresholdInMillis, int triesUntilDelayIncrease, int delayIncreaseMultiplier) {
        this.maxTriesWithYield = maxTriesWithYield;
        this.maxTriesWithDelay = maxTriesWithDelay;
        this.delayBetweenTriesInMillis = delayBetweenTriesInMillis;
        this.delayThresholdInMillis = delayThresholdInMillis;
        this.triesUntilDelayIncrease = triesUntilDelayIncrease;
        this.delayIncreaseMultiplier = delayIncreaseMultiplier;
    }

    public Strategy() {
        this.maxTriesWithYield = Strategy.$default$maxTriesWithYield();
        this.maxTriesWithDelay = Strategy.$default$maxTriesWithDelay();
        this.delayBetweenTriesInMillis = Strategy.$default$delayBetweenTriesInMillis();
        this.delayThresholdInMillis = Strategy.$default$delayThresholdInMillis();
        this.triesUntilDelayIncrease = Strategy.$default$triesUntilDelayIncrease();
        this.delayIncreaseMultiplier = Strategy.$default$delayIncreaseMultiplier();
    }

    public static class StrategyBuilder {
        private boolean maxTriesWithYield$set;
        private int maxTriesWithYield;
        private boolean maxTriesWithDelay$set;
        private int maxTriesWithDelay;
        private boolean delayBetweenTriesInMillis$set;
        private long delayBetweenTriesInMillis;
        private boolean delayThresholdInMillis$set;
        private long delayThresholdInMillis;
        private boolean triesUntilDelayIncrease$set;
        private int triesUntilDelayIncrease;
        private boolean delayIncreaseMultiplier$set;
        private int delayIncreaseMultiplier;

        StrategyBuilder() {
        }

        public StrategyBuilder maxTriesWithYield(int maxTriesWithYield) {
            this.maxTriesWithYield = maxTriesWithYield;
            this.maxTriesWithYield$set = true;
            return this;
        }

        public StrategyBuilder maxTriesWithDelay(int maxTriesWithDelay) {
            this.maxTriesWithDelay = maxTriesWithDelay;
            this.maxTriesWithDelay$set = true;
            return this;
        }

        public StrategyBuilder delayBetweenTriesInMillis(long delayBetweenTriesInMillis) {
            this.delayBetweenTriesInMillis = delayBetweenTriesInMillis;
            this.delayBetweenTriesInMillis$set = true;
            return this;
        }

        public StrategyBuilder delayThresholdInMillis(long delayThresholdInMillis) {
            this.delayThresholdInMillis = delayThresholdInMillis;
            this.delayThresholdInMillis$set = true;
            return this;
        }

        public StrategyBuilder triesUntilDelayIncrease(int triesUntilDelayIncrease) {
            this.triesUntilDelayIncrease = triesUntilDelayIncrease;
            this.triesUntilDelayIncrease$set = true;
            return this;
        }

        public StrategyBuilder delayIncreaseMultiplier(int delayIncreaseMultiplier) {
            this.delayIncreaseMultiplier = delayIncreaseMultiplier;
            this.delayIncreaseMultiplier$set = true;
            return this;
        }

        public Strategy build() {
            int maxTriesWithYield = this.maxTriesWithYield;
            if (!this.maxTriesWithYield$set) {
                maxTriesWithYield = Strategy.$default$maxTriesWithYield();
            }
            int maxTriesWithDelay = this.maxTriesWithDelay;
            if (!this.maxTriesWithDelay$set) {
                maxTriesWithDelay = Strategy.$default$maxTriesWithDelay();
            }
            long delayBetweenTriesInMillis = this.delayBetweenTriesInMillis;
            if (!this.delayBetweenTriesInMillis$set) {
                delayBetweenTriesInMillis = Strategy.$default$delayBetweenTriesInMillis();
            }
            long delayThresholdInMillis = this.delayThresholdInMillis;
            if (!this.delayThresholdInMillis$set) {
                delayThresholdInMillis = Strategy.$default$delayThresholdInMillis();
            }
            int triesUntilDelayIncrease = this.triesUntilDelayIncrease;
            if (!this.triesUntilDelayIncrease$set) {
                triesUntilDelayIncrease = Strategy.$default$triesUntilDelayIncrease();
            }
            int delayIncreaseMultiplier = this.delayIncreaseMultiplier;
            if (!this.delayIncreaseMultiplier$set) {
                delayIncreaseMultiplier = Strategy.$default$delayIncreaseMultiplier();
            }
            return new Strategy(maxTriesWithYield, maxTriesWithDelay, delayBetweenTriesInMillis, delayThresholdInMillis, triesUntilDelayIncrease, delayIncreaseMultiplier);
        }

        public String toString() {
            return "Strategy.StrategyBuilder(maxTriesWithYield=" + this.maxTriesWithYield + ", maxTriesWithDelay=" + this.maxTriesWithDelay + ", delayBetweenTriesInMillis=" + this.delayBetweenTriesInMillis + ", delayThresholdInMillis=" + this.delayThresholdInMillis + ", triesUntilDelayIncrease=" + this.triesUntilDelayIncrease + ", delayIncreaseMultiplier=" + this.delayIncreaseMultiplier + ")";
        }
    }
}

