/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.trial;

import com.littlesaints.protean.functions.trial.AbstractTrial;
import com.littlesaints.protean.functions.trial.Strategy;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FnTrial<T, R>
extends AbstractTrial<R>
implements Function<T, R> {
    private static final Logger log = LogManager.getLogger(FnTrial.class);
    private final Function<T, R> supplier;

    public static <T, R> FnTrial<T, R> ofNullable(Strategy strategy, Function<T, R> op) {
        return FnTrial.of(strategy, op, Objects::nonNull, r -> null);
    }

    public static <T, R> FnTrial<T, Optional<R>> ofOptional(Strategy strategy, Function<T, R> op) {
        return FnTrial.of(strategy, t -> Optional.ofNullable(op.apply(t)), Optional::isPresent, r -> Optional.empty());
    }

    public static <T, R> FnTrial<T, R> of(Strategy strategy, Function<T, R> op, Predicate<R> successfulOpTest, UnaryOperator<R> onTrialsExhaustion) {
        return new FnTrial<T, R>(strategy, op, successfulOpTest, onTrialsExhaustion);
    }

    private FnTrial(Strategy strategy, Function<T, R> op, Predicate<R> successfulOpTest, UnaryOperator<R> onTrialsExhaustion) {
        super(strategy, successfulOpTest, onTrialsExhaustion);
        this.supplier = op;
    }

    @Override
    public R apply(T t) {
        return (R)this.get(() -> this.supplier.apply(t));
    }
}

