/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.trial;

import com.littlesaints.protean.functions.trial.Strategy;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTrial<T> {
    private static final Logger log = LogManager.getLogger(AbstractTrial.class);
    private final Strategy strategy;
    private final Predicate<T> successfulOpTest;
    private final UnaryOperator<T> onTrialsExhaustion;
    private final State state = new State();
    private final Predicate<?> trialValidator;
    private final Runnable delayAdjuster;

    AbstractTrial(Strategy strategy, Predicate<T> successfulOpTest, UnaryOperator<T> onTrialsExhaustion) {
        strategy.validate();
        this.strategy = strategy.toBuilder().build();
        this.successfulOpTest = successfulOpTest;
        this.onTrialsExhaustion = onTrialsExhaustion;
        this.trialValidator = this.getTrialValidator(this.strategy);
        this.delayAdjuster = this.getDelayAdjuster(this.strategy);
    }

    protected T get(Supplier<T> op) {
        T result;
        this.state.reset(this.strategy);
        do {
            if (!this.successfulOpTest.test(result = op.get())) continue;
            return result;
        } while (this.test());
        return (T)this.onTrialsExhaustion.apply(result);
    }

    private boolean test() {
        if (this.trialValidator.test(null)) {
            if (this.state.currentDelayBetweenTriesInMillis > 0L) {
                try {
                    Thread.sleep(this.state.currentDelayBetweenTriesInMillis);
                }
                catch (InterruptedException e) {
                    log.warn("Error during Thread.sleep.", (Throwable)e);
                }
            }
            this.delayAdjuster.run();
            return true;
        }
        return false;
    }

    private Predicate<?> getTrialValidator(Strategy strategy) {
        Predicate<Object> trialValidator;
        int strategyMaxTriesWithDelay = strategy.getMaxTriesWithDelay();
        if (strategy.getMaxTriesWithYield() > 0) {
            int strategyMaxTriesWithYield = this.strategy.getMaxTriesWithYield();
            trialValidator = strategyMaxTriesWithDelay == -1 ? x -> {
                if (this.state.attemptedTriesWithYield < strategyMaxTriesWithYield) {
                    Thread.yield();
                    ++this.state.attemptedTriesWithYield;
                }
                return true;
            } : x -> {
                if (this.state.attemptedTriesWithYield < strategyMaxTriesWithYield) {
                    Thread.yield();
                    ++this.state.attemptedTriesWithYield;
                    return true;
                }
                if (this.state.attemptedTriesWithDelay < strategyMaxTriesWithDelay) {
                    ++this.state.attemptedTriesWithDelay;
                    return true;
                }
                return false;
            };
        } else {
            trialValidator = strategyMaxTriesWithDelay == -1 ? x -> true : x -> {
                if (this.state.attemptedTriesWithDelay < strategyMaxTriesWithDelay) {
                    ++this.state.attemptedTriesWithDelay;
                    return true;
                }
                return false;
            };
        }
        return trialValidator;
    }

    private Runnable getDelayAdjuster(Strategy strategy) {
        long strategyDelayThresholdInMillis = strategy.getDelayThresholdInMillis();
        int strategyTriesUntilDelayIncrease = strategy.getTriesUntilDelayIncrease();
        int strategyDelayIncreaseMultiplier = strategy.getDelayIncreaseMultiplier();
        Runnable delayAdjuster = strategyTriesUntilDelayIncrease <= -1 || strategy.getDelayBetweenTriesInMillis() == strategyDelayThresholdInMillis || strategyDelayIncreaseMultiplier == 1 ? () -> {} : () -> {
            if (this.state.currentDelayBetweenTriesInMillis < strategyDelayThresholdInMillis) {
                --this.state.remainingTriesUntilDelayIncrease;
                if (this.state.remainingTriesUntilDelayIncrease == 0L) {
                    this.state.remainingTriesUntilDelayIncrease = strategyTriesUntilDelayIncrease;
                    this.state.currentDelayBetweenTriesInMillis = Math.min(this.state.currentDelayBetweenTriesInMillis * (long)strategyDelayIncreaseMultiplier, strategyDelayThresholdInMillis);
                }
            }
        };
        return delayAdjuster;
    }

    public State getState() {
        return this.state;
    }

    public static class State {
        private long currentDelayBetweenTriesInMillis;
        private int attemptedTriesWithDelay;
        private int attemptedTriesWithYield;
        private long remainingTriesUntilDelayIncrease;

        private void reset(Strategy strategy) {
            this.attemptedTriesWithYield = 0;
            this.attemptedTriesWithDelay = 0;
            this.currentDelayBetweenTriesInMillis = strategy.getDelayBetweenTriesInMillis();
            this.remainingTriesUntilDelayIncrease = strategy.getTriesUntilDelayIncrease();
        }

        public long getCurrentDelayBetweenTriesInMillis() {
            return this.currentDelayBetweenTriesInMillis;
        }

        public int getAttemptedTriesWithDelay() {
            return this.attemptedTriesWithDelay;
        }

        public int getAttemptedTriesWithYield() {
            return this.attemptedTriesWithYield;
        }

        public long getRemainingTriesUntilDelayIncrease() {
            return this.remainingTriesUntilDelayIncrease;
        }
    }
}

