/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.streams;

import com.littlesaints.protean.functions.XFunction;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class Try<T, R>
implements Function<T, R> {
    private final XFunction<T, R> mapper;
    private BiFunction<T, Exception, R> failureMapper = (t, e) -> null;
    private Consumer<T> finallyOp = t -> {};
    private BiFunction<T, R, R> successOp = (t, r) -> r;

    private Try(XFunction<T, R> mapper) {
        this.mapper = mapper;
    }

    public static <T, R> Try<T, R> evaluate(XFunction<T, R> mapper) {
        Objects.requireNonNull(mapper);
        return new Try<T, R>(mapper);
    }

    public static <T, R> Try<T, Optional<R>> wrapWithOptional(Try<T, R> tryFn) {
        Objects.requireNonNull(tryFn);
        return tryFn.wrapWithOptional();
    }

    public Try<T, Optional<R>> wrapWithOptional() {
        return Try.evaluate(t -> Optional.ofNullable(this.mapper.apply(t))).onSuccess((t, or) -> this.successOp.apply(t, or.orElse(null))).onException((t, x) -> Optional.ofNullable(this.failureMapper.apply(t, (Exception)x))).onFinally(this.finallyOp);
    }

    public Try<T, R> onSuccess(BiConsumer<T, R> successOp) {
        Objects.requireNonNull(successOp);
        this.successOp = (t, r) -> {
            successOp.accept(t, r);
            return r;
        };
        return this;
    }

    public Try<T, R> onException(BiFunction<T, Exception, R> failureMapper) {
        Objects.requireNonNull(failureMapper);
        this.failureMapper = failureMapper;
        return this;
    }

    public Try<T, R> onFailure(BiConsumer<T, Exception> failureOp) {
        Objects.requireNonNull(this.failureMapper);
        this.failureMapper = (t, e) -> {
            failureOp.accept((Object)t, (Exception)e);
            return null;
        };
        return this;
    }

    public Try<T, R> onFinally(Consumer<T> finallyOp) {
        Objects.requireNonNull(this.finallyOp);
        this.finallyOp = finallyOp;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T t) {
        try {
            R r = this.successOp.apply(t, this.mapper.apply(t));
            return r;
        }
        catch (Exception e) {
            R r = this.failureMapper.apply(t, e);
            return r;
        }
        catch (Throwable r) {
            R r2 = this.failureMapper.apply(t, new Exception(r));
            return r2;
        }
        finally {
            this.finallyOp.accept(t);
        }
    }
}

