/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.streams;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class Switch<T, U, R>
implements Function<T, R> {
    private final Function<T, U> test;
    private Map<Predicate<U>, BiFunction<T, U, R>> cases = new LinkedHashMap<Predicate<U>, BiFunction<T, U, R>>(0);
    private BiFunction<T, U, R> defaultCase = (t, u) -> null;

    private Switch(Function<T, U> test) {
        this.test = test;
    }

    public static <T, U, R> Switch<T, U, Optional<R>> wrapWithOptional(Switch<T, U, R> fx) {
        return fx.wrapWithOptional();
    }

    public Switch<T, U, Optional<R>> wrapWithOptional() {
        Switch<Object, Object, Optional> fx = Switch.evaluate(this.test).orDefault((t, u) -> Optional.ofNullable(this.defaultCase.apply(t, u)));
        this.cases.forEach((k, v) -> fx.cases.put((Predicate)k, (t, u) -> Optional.ofNullable(v.apply(t, u))));
        return fx;
    }

    public static <T, U, R> Switch<T, U, R> evaluate(Function<T, U> mapper) {
        return new Switch<T, U, R>(mapper);
    }

    public Switch<T, U, R> when(Predicate<U> predicate, BiFunction<T, U, R> mapper) {
        this.cases.put(predicate, mapper);
        return this;
    }

    public Switch<T, U, R> orDefault(BiFunction<T, U, R> mapper) {
        this.defaultCase = mapper;
        return this;
    }

    @Override
    public R apply(T t) {
        Object u = this.test.apply(t);
        return this.cases.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(u)).findFirst().map(Map.Entry::getValue).orElse(this.defaultCase).apply(t, u);
    }
}

