/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.streams;

import java.util.Spliterator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;

public class StreamSource<T>
implements Supplier<Stream<T>>,
AutoCloseable {
    @NonNull
    private final Supplier<T> provider;
    private final Supplier<Boolean> doWhile;
    private final int parallelism;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final int characteristics;

    @Override
    public void close() {
        this.isClosing.set(true);
    }

    @Override
    public Stream<T> get() {
        _Spliterator spliterator = new _Spliterator(this.parallelism);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(this::close);
    }

    private static <T> Supplier<Boolean> $default$doWhile() {
        return () -> Boolean.TRUE;
    }

    private static <T> int $default$parallelism() {
        return ForkJoinPool.getCommonPoolParallelism();
    }

    private static <T> int $default$characteristics() {
        return 0;
    }

    StreamSource(@NonNull Supplier<T> provider, Supplier<Boolean> doWhile, int parallelism, int characteristics) {
        if (provider == null) {
            throw new NullPointerException("provider is marked @NonNull but is null");
        }
        this.provider = provider;
        this.doWhile = doWhile;
        this.parallelism = parallelism;
        this.characteristics = characteristics;
    }

    public static <T> StreamSourceBuilder<T> builder() {
        return new StreamSourceBuilder();
    }

    public static class StreamSourceBuilder<T> {
        private Supplier<T> provider;
        private boolean doWhile$set;
        private Supplier<Boolean> doWhile;
        private boolean parallelism$set;
        private int parallelism;
        private boolean characteristics$set;
        private int characteristics;

        StreamSourceBuilder() {
        }

        public StreamSourceBuilder<T> provider(Supplier<T> provider) {
            this.provider = provider;
            return this;
        }

        public StreamSourceBuilder<T> doWhile(Supplier<Boolean> doWhile) {
            this.doWhile = doWhile;
            this.doWhile$set = true;
            return this;
        }

        public StreamSourceBuilder<T> parallelism(int parallelism) {
            this.parallelism = parallelism;
            this.parallelism$set = true;
            return this;
        }

        public StreamSourceBuilder<T> characteristics(int characteristics) {
            this.characteristics = characteristics;
            this.characteristics$set = true;
            return this;
        }

        public StreamSource<T> build() {
            Supplier doWhile = this.doWhile;
            if (!this.doWhile$set) {
                doWhile = StreamSource.$default$doWhile();
            }
            int parallelism = this.parallelism;
            if (!this.parallelism$set) {
                parallelism = StreamSource.$default$parallelism();
            }
            int characteristics = this.characteristics;
            if (!this.characteristics$set) {
                characteristics = StreamSource.$default$characteristics();
            }
            return new StreamSource<T>(this.provider, doWhile, parallelism, characteristics);
        }

        public String toString() {
            return "StreamSource.StreamSourceBuilder(provider=" + this.provider + ", doWhile=" + this.doWhile + ", parallelism=" + this.parallelism + ", characteristics=" + this.characteristics + ")";
        }
    }

    private class _Spliterator
    implements Spliterator<T> {
        private final Predicate<Consumer<? super T>> advanceAction = action -> {
            if (((Boolean)StreamSource.this.doWhile.get()).booleanValue()) {
                action.accept(StreamSource.this.provider.get());
                return !StreamSource.this.isClosing.get();
            }
            return false;
        };
        private int estimatedSize;

        private _Spliterator(int estimatedSize) {
            this.estimatedSize = estimatedSize;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.advanceAction.test(action);
        }

        @Override
        public Spliterator<T> trySplit() {
            return new _Spliterator(--this.estimatedSize);
        }

        @Override
        public long estimateSize() {
            return this.estimatedSize;
        }

        @Override
        public int characteristics() {
            return StreamSource.this.characteristics;
        }
    }
}

