/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.streams;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class If<T, R>
implements Function<T, R> {
    private final Predicate<T> test;
    private Function<T, R> thenMapper = t -> null;
    private Map<Predicate<T>, Function<T, R>> elseIfs = new LinkedHashMap<Predicate<T>, Function<T, R>>(0);
    private Function<T, R> elseMapper = t -> null;

    private If(Predicate<T> test) {
        this.test = test;
    }

    public static <T, R> If<T, Optional<R>> wrapWithOptional(If<T, R> fx) {
        return fx.wrapWithOptional();
    }

    public static <T, R> If<T, R> test(Predicate<T> predicate) {
        return new If<T, R>(predicate);
    }

    public If<T, Optional<R>> wrapWithOptional() {
        If<Object, Optional> fx = If.test(this.test).then(t -> Optional.ofNullable(this.thenMapper.apply(t))).orElse(t -> Optional.ofNullable(this.elseMapper.apply(t)));
        this.elseIfs.forEach((k, v) -> fx.elseIfs.put((Predicate)k, t -> Optional.ofNullable(v.apply(t))));
        return fx;
    }

    public If<T, R> then(Function<T, R> mapper) {
        this.thenMapper = mapper;
        return this;
    }

    public If<T, R> elseIf(Predicate<T> predicate, Function<T, R> mapper) {
        this.elseIfs.put(predicate, mapper);
        return this;
    }

    public If<T, R> orElse(Function<T, R> mapper) {
        this.elseMapper = mapper;
        return this;
    }

    @Override
    public R apply(T t) {
        R result = this.test.test(t) ? this.thenMapper.apply(t) : this.elseIfs.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(t)).findFirst().map(Map.Entry::getValue).orElse(this.elseMapper).apply(t);
        return result;
    }
}

