/*
 * Decompiled with CFR 0.152.
 */
package com.littlesaints.protean.functions.streams;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.LongPredicate;
import java.util.function.ToIntFunction;

public class Aggregator<T, R>
implements Function<T, Optional<R>> {
    private final ToIntFunction<T> metricResolver;
    private final LongPredicate predicateToContinueAggregating;
    private final Function<Collection<T>, R> mapper;
    private final LongAdder adder = new LongAdder();
    private final Collection<T> collection = new ArrayList<T>();

    public static <T, R> Aggregator<T, R> of(ToIntFunction<T> metricResolver, LongPredicate predicateToContinueAggregating, Function<Collection<T>, R> mapper) {
        return new Aggregator<T, R>(metricResolver, predicateToContinueAggregating, mapper);
    }

    public static <T> Aggregator<T, Collection<T>> of(ToIntFunction<T> metricResolver, LongPredicate predicateToContinueAggregating) {
        return Aggregator.of(metricResolver, predicateToContinueAggregating, c -> c);
    }

    @Override
    public Optional<R> apply(T t) {
        Optional<Object> result;
        int metric = this.metricResolver.applyAsInt(t);
        this.adder.add(metric);
        if (this.predicateToContinueAggregating.test(this.adder.sum())) {
            result = Optional.empty();
        } else {
            result = Optional.ofNullable(this.mapper.apply(new ArrayList<T>(this.collection)));
            this.adder.reset();
            this.adder.add(metric);
            this.collection.clear();
        }
        this.collection.add(t);
        return result;
    }

    private Aggregator(ToIntFunction<T> metricResolver, LongPredicate predicateToContinueAggregating, Function<Collection<T>, R> mapper) {
        this.metricResolver = metricResolver;
        this.predicateToContinueAggregating = predicateToContinueAggregating;
        this.mapper = mapper;
    }
}

