/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;

public class ServiceUtils {
    private static String removeComment(String line) {
        int commentStart = line.indexOf(35);
        if (commentStart >= 0) {
            return line.substring(0, commentStart);
        }
        return line;
    }

    private static boolean isClassName(String line) {
        return line.matches("[A-z][A-z.0-9]+");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<? extends Class<?>> loadClassesFromJarService(JarFile jar, String path) {
        ZipEntry entry = jar.getEntry(path);
        if (entry == null) return Stream.empty();
        try (InputStream inputStream = jar.getInputStream(entry);){
            Stream<? extends Class<?>> stream = ServiceUtils.loadClassesFromService(inputStream);
            return stream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Stream.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Stream<? extends Class<?>> loadClassesFromFileService(File modLocation, String path) {
        try (FileInputStream fileInputStream2222 = new FileInputStream(new File(modLocation, path));){
            Stream<? extends Class<?>> stream = ServiceUtils.loadClassesFromService(fileInputStream2222);
            return stream;
        }
        catch (FileNotFoundException fileInputStream2222) {
            return Stream.empty();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Stream.empty();
    }

    public static List<String> loadClassNamesFromService(InputStream inputStream) {
        ArrayList<String> r = new ArrayList<String>();
        try (Scanner s = new Scanner(inputStream);){
            while (s.hasNextLine()) {
                r.add(s.nextLine());
            }
            List<String> list = r.stream().map(ServiceUtils::removeComment).map(String::trim).filter(ServiceUtils::isClassName).collect(Collectors.toList());
            return list;
        }
    }

    public static Stream<? extends Class<?>> loadClassesFromService(InputStream inputStream) {
        return ServiceUtils.loadClassNamesFromService(inputStream).stream().flatMap(className -> {
            try {
                return Stream.of(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                return Stream.empty();
            }
        });
    }
}

