/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.impl.ISerializerBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class Registry {
    private static Map<String, String> channelByPacketClassName = new HashMap<String, String>();
    private static Map<String, Integer> packetIdByPacketClassName = new HashMap<String, Integer>();
    private static Map<Pair<String, Integer>, String> packetClassNameByChannelId = new HashMap<Pair<String, Integer>, String>();
    private static Map<String, ISerializerBase> serializerByPacketClassName = new HashMap<String, ISerializerBase>();

    static String getChannelForPacket(String className) {
        return channelByPacketClassName.get(className);
    }

    static List<String> getPacketsForChannel(String channel) {
        return channelByPacketClassName.entrySet().stream().filter(i -> ((String)i.getValue()).equals(channel)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static int getPacketId(String className) throws IllegalArgumentException {
        Integer exists = packetIdByPacketClassName.get(className);
        if (exists == null) {
            throw new IllegalArgumentException("Packet is not registered: " + className + ". Need to add @ElegantPacket annotation to packet class");
        }
        return exists;
    }

    static String getPacketName(String channel, int id) {
        return packetClassNameByChannelId.get(Pair.of((Object)channel, (Object)id));
    }

    public static <A extends IByteBufSerializable> ISerializerBase<A> getSerializer(String className) {
        return serializerByPacketClassName.get(className);
    }

    public static <A extends IByteBufSerializable> ISerializerBase<A> getSerializerFor(Class<A> serializable) {
        return Registry.getSerializer(serializable.getCanonicalName());
    }

    static void registerSerializer(Class<? extends IByteBufSerializable> serializable, ISerializerBase serializer) {
        serializerByPacketClassName.put(serializable.getCanonicalName(), serializer);
    }

    static void register(PacketInfo p) {
        ISerializerBase serializer = serializerByPacketClassName.get(p.className);
        if (serializer == null) {
            throw new RuntimeException("Serializer for packet " + p.className + " not found");
        }
        channelByPacketClassName.put(p.className, p.channel);
        packetIdByPacketClassName.put(p.className, p.id);
        packetClassNameByChannelId.put((Pair<String, Integer>)Pair.of((Object)p.channel, (Object)p.id), p.className);
    }

    static final class PacketInfo {
        public final String channel;
        public final int id;
        public final String className;

        public PacketInfo(String channel, int id, String className) {
            this.channel = channel;
            this.id = id;
            this.className = className;
        }

        public String getChannel() {
            return this.channel;
        }

        public int getId() {
            return this.id;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketInfo)) {
                return false;
            }
            PacketInfo other = (PacketInfo)o;
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            result = result * 59 + this.getId();
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "Registry.PacketInfo(channel=" + this.getChannel() + ", id=" + this.getId() + ", className=" + this.getClassName() + ")";
        }
    }
}

