/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.CCLNetworkImpl;
import hohserg.elegant.networking.impl.ForgeNetworkImpl;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;

public interface Network<PacketRepresentation> {
    public static final Network defaultImpl = Loader.isModLoaded((String)"codechickenlib") ? new CCLNetworkImpl() : new ForgeNetworkImpl();

    public static Network getNetwork() {
        return defaultImpl;
    }

    public void sendToPlayer(ServerToClientPacket var1, EntityPlayerMP var2);

    public void sendToClients(ServerToClientPacket var1);

    public void sendPacketToAllAround(ServerToClientPacket var1, World var2, double var3, double var5, double var7, double var9);

    public void sendToDimension(ServerToClientPacket var1, World var2);

    public void sendToChunk(ServerToClientPacket var1, World var2, int var3, int var4);

    public void sendToServer(ClientToServerPacket var1);

    public void onReceiveClient(PacketRepresentation var1, String var2);

    public void onReceiveServer(PacketRepresentation var1, EntityPlayerMP var2, String var3);

    public void registerChannel(String var1);

    default public void checkSendingSide(IByteBufSerializable packet) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT && packet instanceof ServerToClientPacket) {
            throw new RuntimeException("Attempt to send ServerToClientPacket from client side: " + packet.getClass().getCanonicalName());
        }
        if (side == Side.SERVER && packet instanceof ClientToServerPacket) {
            throw new RuntimeException("Attempt to send ClientToServerPacket from server side: " + packet.getClass().getCanonicalName());
        }
    }
}

