/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.Refs;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.impl.Config;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.Registry;
import hohserg.elegant.networking.impl.SerializerMark;
import hohserg.elegant.networking.utils.PrintUtils;
import hohserg.elegant.networking.utils.ServiceUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Init {
    public static Config initConfig(File configFolder) {
        File configFile = new File(configFolder, "elegant_networking.cfg");
        Config config = new Config();
        if (configFile.exists()) {
            Init.loadConfig(configFile, config);
        } else {
            Init.saveDefaultConfig(configFile, config);
        }
        return config;
    }

    private static void saveDefaultConfig(File configFile, Config config) {
        try (FileWriter fileWriter = new FileWriter(configFile);){
            fileWriter.write("# How many bytes can contains received packet\n");
            fileWriter.write("packetSizeLimit = " + config.packetSizeLimit + "\n");
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File configFile, Config config) {
        try (FileInputStream fileInputStream = new FileInputStream(configFile);
             Scanner s = new Scanner(fileInputStream);){
            while (s.hasNextLine()) {
                String[] split;
                String line;
                int commentStart = (line = s.nextLine()).indexOf(35);
                String withoutComment = line.substring(0, commentStart == -1 ? line.length() : commentStart);
                if (withoutComment.isEmpty() || (split = withoutComment.split("=")).length != 2) continue;
                String fieldName = split[0].trim();
                String value = split[1].trim();
                if (!fieldName.equals("packetSizeLimit")) continue;
                config.packetSizeLimit = Integer.parseInt(value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void registerAllPackets(List<ModInfo> mods, Consumer<String> msgPrintln, Consumer<String> errorPrintln, Consumer<String> channelNameConsumer) {
        HashSet<String> excludedModid = new HashSet<String>();
        excludedModid.add("minecraft");
        PrintWriter errorWriter = PrintUtils.getWriterForStringConsumer(errorPrintln);
        HashSet<String> channelsToRegister = new HashSet<String>();
        for (ModInfo mod : mods) {
            if (excludedModid.contains(mod.modid)) continue;
            try {
                List<Object> packets;
                msgPrintln.accept("Started registration of elegant packets for modid " + mod.modid);
                File source = mod.getSource();
                Predicate<Class> packetInterfaceFilter = cl -> Arrays.stream(cl.getInterfaces()).anyMatch(i -> i.getCanonicalName().equals("hohserg.elegant.networking.api.ClientToServerPacket") || i.getCanonicalName().equals("hohserg.elegant.networking.api.ServerToClientPacket"));
                if (source.isDirectory()) {
                    packets = Stream.concat(ServiceUtils.loadClassesFromFileService(source, Refs.getServicePath("hohserg.elegant.networking.api.ClientToServerPacket")), ServiceUtils.loadClassesFromFileService(source, Refs.getServicePath("hohserg.elegant.networking.api.ServerToClientPacket"))).filter(packetInterfaceFilter).collect(Collectors.toList());
                    ServiceUtils.loadClassesFromFileService(source, Refs.getServicePath("hohserg.elegant.networking.impl.ISerializer")).forEachOrdered(cl -> Init.registerSerializer(cl, errorWriter));
                } else {
                    try (JarFile jar = new JarFile(source);){
                        packets = Stream.concat(ServiceUtils.loadClassesFromJarService(jar, Refs.getServicePath("hohserg.elegant.networking.api.ClientToServerPacket")), ServiceUtils.loadClassesFromJarService(jar, Refs.getServicePath("hohserg.elegant.networking.api.ServerToClientPacket"))).filter(packetInterfaceFilter).collect(Collectors.toList());
                        ServiceUtils.loadClassesFromJarService(jar, Refs.getServicePath("hohserg.elegant.networking.impl.ISerializer")).forEachOrdered(cl -> Init.registerSerializer(cl, errorWriter));
                    }
                    catch (IOException e) {
                        e.printStackTrace(errorWriter);
                        packets = new ArrayList();
                    }
                }
                for (int i = 0; i < packets.size(); ++i) {
                    int id = i + 1;
                    Registry.register(new Registry.PacketInfo(mod.getModid(), id, ((Class)packets.get(i)).getCanonicalName()));
                    channelsToRegister.add(mod.getModid());
                    msgPrintln.accept("Registered packet " + ((Class)packets.get(i)).getSimpleName() + " for channel " + mod.getModid() + " with id " + id);
                }
            }
            catch (Throwable e) {
                errorWriter.println("Unable to register elegant packets for mod " + mod.getModid() + ". Caused by:");
                e.printStackTrace(errorWriter);
                errorWriter.println();
            }
        }
        channelsToRegister.forEach(channelNameConsumer);
    }

    private static void registerSerializer(Class<?> cl, PrintWriter errorPrintln) {
        Class<? extends IByteBufSerializable> serializable = cl.getAnnotation(SerializerMark.class).packetClass();
        try {
            Registry.registerSerializer(serializable, (ISerializerBase)cl.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            errorPrintln.println("Unable to create serializer for " + serializable);
            e.printStackTrace(errorPrintln);
        }
    }

    public static final class ModInfo {
        private final String modid;
        private final File source;

        public ModInfo(String modid, File source) {
            this.modid = modid;
            this.source = source;
        }

        public String getModid() {
            return this.modid;
        }

        public File getSource() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModInfo)) {
                return false;
            }
            ModInfo other = (ModInfo)o;
            String this$modid = this.getModid();
            String other$modid = other.getModid();
            if (this$modid == null ? other$modid != null : !this$modid.equals(other$modid)) {
                return false;
            }
            File this$source = this.getSource();
            File other$source = other.getSource();
            return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $modid = this.getModid();
            result = result * 59 + ($modid == null ? 43 : $modid.hashCode());
            File $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
            return result;
        }

        public String toString() {
            return "Init.ModInfo(modid=" + this.getModid() + ", source=" + this.getSource() + ")";
        }
    }
}

