/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import com.google.common.collect.SetMultimap;
import com.mojang.realmsclient.gui.ChatFormatting;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.ElegantNetworking;
import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.SerializerMark;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;

@Mod(modid="elegant_networking", name="ElegantNetworking")
public class Main {
    private static Set<String> channelsToRegister = new HashSet<String>();
    public static Logger log;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws ClassNotFoundException {
        log = event.getModLog();
        for (ModContainer modContainer : Loader.instance().getActiveModList()) {
            SetMultimap annotationsFor = event.getAsmData().getAnnotationsFor(modContainer);
            if (annotationsFor == null) continue;
            List rawPackets = annotationsFor.get((Object)"hohserg.elegant.networking.api.ElegantPacket").stream().filter(a -> {
                try {
                    return Arrays.stream(Class.forName(a.getClassName()).getInterfaces()).anyMatch(i -> i == ClientToServerPacket.class || i == ServerToClientPacket.class);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return false;
                }
            }).collect(Collectors.toList());
            Map<String, Class> rawSerializers = annotationsFor.get((Object)"hohserg.elegant.networking.impl.SerializerMark").stream().flatMap(a -> {
                try {
                    return Stream.of(Class.forName(a.getClassName()));
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return Stream.empty();
                }
            }).filter(aClass -> Arrays.stream(aClass.getInterfaces()).anyMatch(i -> i == ISerializer.class)).collect(Collectors.toMap(cl -> cl.getAnnotation(SerializerMark.class).packetClass().getCanonicalName(), cl -> cl));
            log.debug("rawSerializers " + rawSerializers);
            if (rawPackets.size() <= 0) continue;
            List packets = rawPackets.stream().map(a -> new ElegantNetworking.PacketInfo(a.getAnnotationInfo().getOrDefault("channel", modContainer.getModId()), a.getClassName())).collect(Collectors.toList());
            packets.stream().map(p -> p.channel).forEach(channelsToRegister::add);
            for (ElegantNetworking.PacketInfo p2 : packets) {
                Class maybeSerializer = rawSerializers.get(p2.className);
                if (maybeSerializer != null) {
                    try {
                        ISerializer o = (ISerializer)maybeSerializer.newInstance();
                        log.info("Register packet " + ChatFormatting.AQUA + Class.forName(p2.className).getSimpleName() + ChatFormatting.RESET + " for channel " + ChatFormatting.AQUA + p2.channel + ChatFormatting.RESET + " with id " + o.packetId());
                        ElegantNetworking.register(p2, o);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        log.error("Unable to instantiate serializer " + maybeSerializer.getName() + " for packet" + ChatFormatting.AQUA + Class.forName(p2.className).getSimpleName() + ChatFormatting.RESET + " for channel " + ChatFormatting.AQUA + p2.channel);
                        e.printStackTrace();
                    }
                    continue;
                }
                log.error("Not found serializer for packet " + ChatFormatting.AQUA + Class.forName(p2.className).getSimpleName() + ChatFormatting.RESET + " for channel " + ChatFormatting.AQUA + p2.channel);
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        channelsToRegister.forEach(ElegantNetworking.getNetwork()::registerChannel);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }
}

