/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public interface ISerializer<Packet> {
    public void serialize(Packet var1, ByteBuf var2);

    public Packet unserialize(ByteBuf var1);

    public int packetId();

    default public void serialize_Boolean_Generic(boolean value, ByteBuf acc) {
        acc.writeBoolean(value);
    }

    default public void serialize_Byte_Generic(byte value, ByteBuf acc) {
        acc.writeByte((int)value);
    }

    default public void serialize_Short_Generic(short value, ByteBuf acc) {
        acc.writeShort((int)value);
    }

    default public void serialize_Int_Generic(int value, ByteBuf acc) {
        acc.writeInt(value);
    }

    default public void serialize_Long_Generic(long value, ByteBuf acc) {
        acc.writeLong(value);
    }

    default public void serialize_Char_Generic(char value, ByteBuf acc) {
        acc.writeChar((int)value);
    }

    default public void serialize_Float_Generic(float value, ByteBuf acc) {
        acc.writeFloat(value);
    }

    default public void serialize_Double_Generic(double value, ByteBuf acc) {
        acc.writeDouble(value);
    }

    default public void serialize_String_Generic(String value, ByteBuf acc) {
        ByteBufUtils.writeUTF8String((ByteBuf)acc, (String)value);
    }

    default public void serialize_NBTTagCompound_Generic(NBTTagCompound value, ByteBuf acc) {
        ByteBufUtils.writeTag((ByteBuf)acc, (NBTTagCompound)value);
    }

    default public void serialize_ItemStack_Generic(ItemStack value, ByteBuf acc) {
        ByteBufUtils.writeItemStack((ByteBuf)acc, (ItemStack)value);
    }

    default public void serialize_FluidStack_Generic(FluidStack value, ByteBuf acc) {
        this.serialize_Fluid_Generic(value.getFluid(), acc);
        acc.writeInt(value.amount);
        if (value.tag != null) {
            acc.writeByte(1);
            this.serialize_NBTTagCompound_Generic(value.tag, acc);
        } else {
            acc.writeByte(0);
        }
    }

    default public void serialize_Item_Generic(Item value, ByteBuf acc) {
        acc.writeShort(Item.func_150891_b((Item)value));
    }

    default public void serialize_Block_Generic(Block value, ByteBuf acc) {
        acc.writeShort(Block.func_149682_b((Block)value));
    }

    default public void serialize_Fluid_Generic(Fluid value, ByteBuf acc) {
        this.serialize_String_Generic(FluidRegistry.getFluidName((Fluid)value), acc);
    }

    default public void serialize_ResourceLocation_Generic(ResourceLocation value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public void serialize_UUID_Generic(UUID value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public boolean unserialize_Boolean_Generic(ByteBuf buf) {
        return buf.readBoolean();
    }

    default public byte unserialize_Byte_Generic(ByteBuf buf) {
        return buf.readByte();
    }

    default public short unserialize_Short_Generic(ByteBuf buf) {
        return buf.readShort();
    }

    default public int unserialize_Int_Generic(ByteBuf buf) {
        return buf.readInt();
    }

    default public long unserialize_Long_Generic(ByteBuf buf) {
        return buf.readLong();
    }

    default public char unserialize_Char_Generic(ByteBuf buf) {
        return buf.readChar();
    }

    default public float unserialize_Float_Generic(ByteBuf buf) {
        return buf.readFloat();
    }

    default public double unserialize_Double_Generic(ByteBuf buf) {
        return buf.readDouble();
    }

    default public String unserialize_String_Generic(ByteBuf buf) {
        return ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    default public NBTTagCompound unserialize_NBTTagCompound_Generic(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    default public ItemStack unserialize_ItemStack_Generic(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    default public FluidStack unserialize_FluidStack_Generic(ByteBuf buf) {
        Fluid fluid = this.unserialize_Fluid_Generic(buf);
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, buf.readInt());
            if (buf.readByte() == 1) {
                stack.tag = this.unserialize_NBTTagCompound_Generic(buf);
            }
            return stack;
        }
        return null;
    }

    default public Item unserialize_Item_Generic(ByteBuf buf) {
        return Item.func_150899_d((int)buf.readShort());
    }

    default public Block unserialize_Block_Generic(ByteBuf buf) {
        return Block.func_149729_e((int)buf.readShort());
    }

    default public Fluid unserialize_Fluid_Generic(ByteBuf buf) {
        return FluidRegistry.getFluid((String)this.unserialize_String_Generic(buf));
    }

    default public ResourceLocation unserialize_ResourceLocation_Generic(ByteBuf buf) {
        return new ResourceLocation(this.unserialize_String_Generic(buf));
    }

    default public UUID unserialize_UUID_Generic(ByteBuf buf) {
        return UUID.fromString(this.unserialize_String_Generic(buf));
    }
}

