/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import cpw.mods.fml.common.Loader;
import hohserg.elegant.networking.impl.CCLNetworkImpl;
import hohserg.elegant.networking.impl.ForgeNetworkImpl;
import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.Network;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ElegantNetworking {
    private static Map<String, String> channelByPacketClassName = new HashMap<String, String>();
    private static Map<String, Integer> packetIdByPacketClassName = new HashMap<String, Integer>();
    private static Map<Pair<String, Integer>, String> packetClassNameByChannelId = new HashMap<Pair<String, Integer>, String>();
    private static Map<String, ISerializer> serializerByPacketClassName = new HashMap<String, ISerializer>();
    private static Network defaultImpl = Loader.isModLoaded((String)"codechickenlib") ? new CCLNetworkImpl() : new ForgeNetworkImpl();

    static String getChannelForPacket(String className) {
        return channelByPacketClassName.get(className);
    }

    static int getPacketId(String className) {
        return packetIdByPacketClassName.get(className);
    }

    static String getPacketName(String channel, int id) {
        return packetClassNameByChannelId.get(Pair.of((Object)channel, (Object)id));
    }

    static ISerializer getSerializer(String className) {
        return serializerByPacketClassName.get(className);
    }

    public static Network getNetwork() {
        return defaultImpl;
    }

    static void register(PacketInfo p, ISerializer serializer) {
        int id = serializer.packetId();
        channelByPacketClassName.put(p.className, p.channel);
        packetIdByPacketClassName.put(p.className, id);
        packetClassNameByChannelId.put((Pair<String, Integer>)Pair.of((Object)p.channel, (Object)id), p.className);
        serializerByPacketClassName.put(p.className, serializer);
    }

    static class PacketInfo {
        public String channel;
        public String className;

        public PacketInfo(String channel, String className) {
            this.channel = channel;
            this.className = className;
        }
    }
}

