/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.impl.ISerializerBase;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public interface ISerializer<Packet>
extends ISerializerBase<Packet> {
    default public void serialize_BlockPos_Generic(BlockPos value, ByteBuf acc) {
        acc.writeInt(value.getX());
        acc.writeInt(value.getY());
        acc.writeInt(value.getZ());
    }

    default public BlockPos unserialize_BlockPos_Generic(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    default public void serialize_CompoundNBT_Generic(CompoundNBT value, ByteBuf acc) {
        if (value != null) {
            try {
                acc.writeBoolean(true);
                CompressedStreamTools.write((CompoundNBT)value, (DataOutput)new ByteBufOutputStream(acc));
            }
            catch (IOException e) {
                throw new EncoderException("Failed to write CompoundNBT to packet.", (Throwable)e);
            }
        } else {
            acc.writeBoolean(false);
        }
    }

    default public CompoundNBT unserialize_CompoundNBT_Generic(ByteBuf buf) {
        if (buf.readBoolean()) {
            try {
                return CompressedStreamTools.read((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
            }
            catch (IOException e) {
                throw new EncoderException("Failed to read CompoundNBT from packet.", (Throwable)e);
            }
        }
        return null;
    }

    default public void serialize_ItemStack_Generic(ItemStack value, ByteBuf acc) {
        new PacketBuffer(acc).writeItemStack(value);
    }

    default public ItemStack unserialize_ItemStack_Generic(ByteBuf buf) {
        return new PacketBuffer(buf).readItemStack();
    }

    default public void serialize_FluidStack_Generic(FluidStack value, ByteBuf acc) {
        new PacketBuffer(acc).writeFluidStack(value);
    }

    default public FluidStack unserialize_FluidStack_Generic(ByteBuf buf) {
        return new PacketBuffer(buf).readFluidStack();
    }

    default public void serialize_Item_Generic(Item value, ByteBuf acc) {
        acc.writeInt(((ForgeRegistry)ForgeRegistries.ITEMS).getID((IForgeRegistryEntry)value));
    }

    default public Item unserialize_Item_Generic(ByteBuf buf) {
        return (Item)((ForgeRegistry)ForgeRegistries.ITEMS).getValue(buf.readInt());
    }

    default public void serialize_Block_Generic(Block value, ByteBuf acc) {
        acc.writeInt(((ForgeRegistry)ForgeRegistries.BLOCKS).getID((IForgeRegistryEntry)value));
    }

    default public Block unserialize_Block_Generic(ByteBuf buf) {
        return (Block)((ForgeRegistry)ForgeRegistries.BLOCKS).getValue(buf.readInt());
    }

    default public void serialize_Fluid_Generic(Fluid value, ByteBuf acc) {
        acc.writeInt(((ForgeRegistry)ForgeRegistries.FLUIDS).getID((IForgeRegistryEntry)value));
    }

    default public Fluid unserialize_Fluid_Generic(ByteBuf buf) {
        return (Fluid)((ForgeRegistry)ForgeRegistries.FLUIDS).getValue(buf.readInt());
    }

    default public void serialize_ResourceLocation_Generic(ResourceLocation value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public ResourceLocation unserialize_ResourceLocation_Generic(ByteBuf buf) {
        return new ResourceLocation(this.unserialize_String_Generic(buf));
    }
}

