/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import com.google.common.base.Preconditions;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.RegistrableSingletonSerializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public interface ISerializer<Packet>
extends ISerializerBase<Packet>,
RegistrableSingletonSerializer {
    default public void serialize_BlockPos_Generic(BlockPos value, ByteBuf acc) {
        acc.writeInt(value.func_177958_n());
        acc.writeInt(value.func_177956_o());
        acc.writeInt(value.func_177952_p());
    }

    default public BlockPos unserialize_BlockPos_Generic(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    default public void serialize_CompoundNBT_Generic(CompoundNBT value, ByteBuf acc) {
        Preconditions.checkNotNull((Object)value);
        try {
            CompressedStreamTools.func_74800_a((CompoundNBT)value, (DataOutput)new ByteBufOutputStream(acc));
        }
        catch (IOException e) {
            throw new EncoderException("Failed to write CompoundNBT to packet.", (Throwable)e);
        }
    }

    default public CompoundNBT unserialize_CompoundNBT_Generic(ByteBuf buf) {
        try {
            return CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)new NBTSizeTracker(0x200000L));
        }
        catch (IOException e) {
            throw new EncoderException("Failed to read CompoundNBT from packet.", (Throwable)e);
        }
    }

    default public void serialize_ItemStack_Generic(ItemStack value, ByteBuf acc) {
        new PacketBuffer(acc).func_150788_a(value);
    }

    default public ItemStack unserialize_ItemStack_Generic(ByteBuf buf) {
        return new PacketBuffer(buf).func_150791_c();
    }

    default public void serialize_FluidStack_Generic(FluidStack value, ByteBuf acc) {
        new PacketBuffer(acc).writeFluidStack(value);
    }

    default public FluidStack unserialize_FluidStack_Generic(ByteBuf buf) {
        return new PacketBuffer(buf).readFluidStack();
    }

    default public void serialize_ResourceLocation_Generic(ResourceLocation value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public ResourceLocation unserialize_ResourceLocation_Generic(ByteBuf buf) {
        return new ResourceLocation(this.unserialize_String_Generic(buf));
    }
}

