/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.Network;
import hohserg.elegant.networking.impl.Registry;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class ForgeNetworkImpl
implements Network<UniversalPacket> {
    private Map<String, SimpleChannel> channels = new HashMap<String, SimpleChannel>();
    private final String NET_COMM_VERSION = "0";

    @Override
    public void sendToPlayer(ServerToClientPacket serverToClientPacket, ServerPlayerEntity player) {
        this.getChannel(serverToClientPacket).send(PacketDistributor.PLAYER.with(() -> player), (Object)this.preparePacket(serverToClientPacket));
    }

    private SimpleChannel getChannel(IByteBufSerializable packet) {
        this.checkSendingSide(packet);
        return this.channels.get(Registry.getChannelForPacket(packet.getClass().getName()));
    }

    @Override
    public void sendToClients(ServerToClientPacket serverToClientPacket) {
        this.getChannel(serverToClientPacket).send(PacketDistributor.ALL.noArg(), (Object)this.preparePacket(serverToClientPacket));
    }

    @Override
    public void sendPacketToAllAround(ServerToClientPacket serverToClientPacket, World world, double x, double y, double z, double range) {
        this.getChannel(serverToClientPacket).send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(x, y, z, range, world.func_201675_m().func_186058_p())), (Object)this.preparePacket(serverToClientPacket));
    }

    @Override
    public void sendToDimension(ServerToClientPacket serverToClientPacket, World world) {
        this.getChannel(serverToClientPacket).send(PacketDistributor.DIMENSION.with(() -> world.func_201675_m().func_186058_p()), (Object)this.preparePacket(serverToClientPacket));
    }

    @Override
    public void sendToChunk(ServerToClientPacket serverToClientPacket, World world, int chunkX, int chunkZ) {
        this.getChannel(serverToClientPacket).send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_212866_a_(chunkX, chunkZ)), (Object)this.preparePacket(serverToClientPacket));
    }

    @Override
    public void sendToServer(ClientToServerPacket packet) {
        this.getChannel(packet).sendToServer((Object)this.preparePacket(packet));
    }

    private ServerToClientUniversalPacket preparePacket(ServerToClientPacket packet) {
        return new ServerToClientUniversalPacket(Registry.getPacketId(packet.getClass().getName()), packet);
    }

    private ClientToServerUniversalPacket preparePacket(ClientToServerPacket packet) {
        return new ClientToServerUniversalPacket(Registry.getPacketId(packet.getClass().getName()), packet);
    }

    @Override
    public void onReceiveClient(UniversalPacket packetRepresent, String channel) {
        ((ServerToClientPacket)this.readObjectFromPacket(packetRepresent)).onReceive(Minecraft.func_71410_x());
    }

    @Override
    public void onReceiveServer(UniversalPacket packetRepresent, ServerPlayerEntity player, String channel) {
        ((ClientToServerPacket)this.readObjectFromPacket(packetRepresent)).onReceive(player);
    }

    private <A> A readObjectFromPacket(UniversalPacket packetRepresent) {
        return packetRepresent.packet;
    }

    @Override
    public void registerChannel(String channel) {
        SimpleChannel simpleNetworkWrapper = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(channel, channel), () -> "0", "0"::equals, "0"::equals);
        this.channels.put(channel, simpleNetworkWrapper);
        simpleNetworkWrapper.registerMessage(0, ServerToClientUniversalPacket.class, UniversalPacket::toBytes, packetBuffer -> {
            ServerToClientUniversalPacket packetRepr = new ServerToClientUniversalPacket();
            packetRepr.fromBytes((ByteBuf)packetBuffer, channel);
            return packetRepr;
        }, (serverToClientUniversalPacket, contextSupplier) -> {
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> this.onReceiveClient((UniversalPacket)serverToClientUniversalPacket, channel));
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        });
        simpleNetworkWrapper.registerMessage(1, ClientToServerUniversalPacket.class, UniversalPacket::toBytes, packetBuffer -> {
            ClientToServerUniversalPacket packetRepr = new ClientToServerUniversalPacket();
            packetRepr.fromBytes((ByteBuf)packetBuffer, channel);
            return packetRepr;
        }, (clientToServerUniversalPacket, contextSupplier) -> {
            ((NetworkEvent.Context)contextSupplier.get()).enqueueWork(() -> this.lambda$null$9(clientToServerUniversalPacket, (Supplier)contextSupplier, channel));
            ((NetworkEvent.Context)contextSupplier.get()).setPacketHandled(true);
        });
    }

    private /* synthetic */ void lambda$null$9(ClientToServerUniversalPacket clientToServerUniversalPacket, Supplier contextSupplier, String channel) {
        this.onReceiveServer(clientToServerUniversalPacket, ((NetworkEvent.Context)contextSupplier.get()).getSender(), channel);
    }

    static class UniversalPacket<A extends IByteBufSerializable> {
        private int id;
        A packet;

        void fromBytes(ByteBuf buf, String channel) {
            this.id = buf.readByte();
            String packetName = Registry.getPacketName(channel, this.id);
            this.packet = (IByteBufSerializable)Registry.getSerializer(packetName).unserialize(buf);
        }

        void toBytes(ByteBuf buf) {
            buf.writeByte(this.id);
            Registry.getSerializer(this.packet.getClass().getName()).serialize(this.packet, buf);
        }

        public UniversalPacket(int id, A packet) {
            this.id = id;
            this.packet = packet;
        }

        public UniversalPacket() {
        }
    }

    static class ServerToClientUniversalPacket
    extends UniversalPacket<ServerToClientPacket> {
        ServerToClientUniversalPacket(int id, ServerToClientPacket packet) {
            super(id, packet);
        }

        public ServerToClientUniversalPacket() {
        }
    }

    static class ClientToServerUniversalPacket
    extends UniversalPacket<ClientToServerPacket> {
        ClientToServerUniversalPacket(int id, ClientToServerPacket packet) {
            super(id, packet);
        }

        public ClientToServerUniversalPacket() {
        }
    }
}

