/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import codechicken.lib.packet.PacketCustom;
import codechicken.lib.packet.PacketCustomChannelBuilder;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.Network;
import hohserg.elegant.networking.impl.Registry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class CCLNetworkImpl
implements Network<PacketCustom> {
    @Override
    public void sendToPlayer(ServerToClientPacket serverToClientPacket, ServerPlayerEntity player) {
        this.preparePacket(serverToClientPacket).sendToPlayer(player);
    }

    @Override
    public void sendToClients(ServerToClientPacket serverToClientPacket) {
        this.preparePacket(serverToClientPacket).sendToClients();
    }

    @Override
    public void sendPacketToAllAround(ServerToClientPacket serverToClientPacket, World world, double x, double y, double z, double range) {
        this.preparePacket(serverToClientPacket).sendPacketToAllAround(x, y, z, range, world.func_201675_m().func_186058_p());
    }

    @Override
    public void sendToDimension(ServerToClientPacket serverToClientPacket, World world) {
        this.preparePacket(serverToClientPacket).sendToDimension(world.func_201675_m().func_186058_p());
    }

    @Override
    public void sendToChunk(ServerToClientPacket serverToClientPacket, World world, int chunkX, int chunkZ) {
        this.preparePacket(serverToClientPacket).sendToChunk(world, chunkX, chunkZ);
    }

    @Override
    public void sendToServer(ClientToServerPacket packet) {
        this.preparePacket(packet).sendToServer();
    }

    private PacketCustom preparePacket(IByteBufSerializable packet) {
        this.checkSendingSide(packet);
        String packetClassName = packet.getClass().getName();
        ISerializerBase serializer = Registry.getSerializer(packetClassName);
        String channel = Registry.getChannelForPacket(packetClassName);
        Integer id = Registry.getPacketId(packetClassName);
        PacketCustom packetCustom = new PacketCustom(new ResourceLocation(channel, channel), id.intValue());
        ByteBuf buffer = Unpooled.buffer();
        serializer.serialize(packet, buffer);
        packetCustom.writeBytes(buffer.array(), 0, buffer.readableBytes());
        return packetCustom;
    }

    @Override
    public void onReceiveClient(PacketCustom packetRepresent, String channel) {
        ((ServerToClientPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(Minecraft.func_71410_x());
    }

    @Override
    public void onReceiveServer(PacketCustom packetRepresent, ServerPlayerEntity player, String channel) {
        ((ClientToServerPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(player);
    }

    private <A> A readObjectFromPacket(PacketCustom packetRepresent, String channel) {
        return Registry.getSerializer(Registry.getPacketName(channel, packetRepresent.getType())).unserialize(packetRepresent.readByteBuf());
    }

    @Override
    public void registerChannel(String channel) {
        PacketCustomChannelBuilder.named((ResourceLocation)new ResourceLocation(channel, channel)).assignClientHandler(() -> () -> (packet, mc, handler) -> this.onReceiveClient(packet, channel)).assignServerHandler(() -> () -> (packet, sender, handler) -> this.onReceiveServer(packet, sender, channel)).build();
    }
}

