/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.impl.ISerializerBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public interface ISerializer<Packet>
extends ISerializerBase<Packet> {
    default public void serialize_BlockPos_Generic(BlockPos value, ByteBuf acc) {
        acc.writeInt(value.getX());
        acc.writeInt(value.getY());
        acc.writeInt(value.getZ());
    }

    default public BlockPos unserialize_BlockPos_Generic(ByteBuf buf) {
        return new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    default public void serialize_NBTTagCompound_Generic(NBTTagCompound value, ByteBuf acc) {
        ByteBufUtils.writeTag((ByteBuf)acc, (NBTTagCompound)value);
    }

    default public NBTTagCompound unserialize_NBTTagCompound_Generic(ByteBuf buf) {
        return ByteBufUtils.readTag((ByteBuf)buf);
    }

    default public void serialize_ItemStack_Generic(ItemStack value, ByteBuf acc) {
        ByteBufUtils.writeItemStack((ByteBuf)acc, (ItemStack)value);
    }

    default public ItemStack unserialize_ItemStack_Generic(ByteBuf buf) {
        return ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    default public void serialize_FluidStack_Generic(FluidStack value, ByteBuf acc) {
        this.serialize_Fluid_Generic(value.getFluid(), acc);
        acc.writeInt(value.amount);
        if (value.tag != null) {
            acc.writeByte(1);
            this.serialize_NBTTagCompound_Generic(value.tag, acc);
        } else {
            acc.writeByte(0);
        }
    }

    default public FluidStack unserialize_FluidStack_Generic(ByteBuf buf) {
        Fluid fluid = this.unserialize_Fluid_Generic(buf);
        if (fluid != null) {
            FluidStack stack = new FluidStack(fluid, buf.readInt());
            if (buf.readByte() == 1) {
                stack.tag = this.unserialize_NBTTagCompound_Generic(buf);
            }
            return stack;
        }
        return null;
    }

    default public void serialize_Item_Generic(Item value, ByteBuf acc) {
        acc.writeShort(Item.getIdFromItem((Item)value));
    }

    default public Item unserialize_Item_Generic(ByteBuf buf) {
        return Item.getItemById((int)buf.readShort());
    }

    default public void serialize_Block_Generic(Block value, ByteBuf acc) {
        acc.writeShort(Block.getIdFromBlock((Block)value));
    }

    default public Block unserialize_Block_Generic(ByteBuf buf) {
        return Block.getBlockById((int)buf.readShort());
    }

    default public void serialize_Fluid_Generic(Fluid value, ByteBuf acc) {
        this.serialize_String_Generic(FluidRegistry.getFluidName((Fluid)value), acc);
    }

    default public Fluid unserialize_Fluid_Generic(ByteBuf buf) {
        return FluidRegistry.getFluid((String)this.unserialize_String_Generic(buf));
    }

    default public void serialize_ResourceLocation_Generic(ResourceLocation value, ByteBuf acc) {
        this.serialize_String_Generic(value.toString(), acc);
    }

    default public ResourceLocation unserialize_ResourceLocation_Generic(ByteBuf buf) {
        return new ResourceLocation(this.unserialize_String_Generic(buf));
    }
}

