/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ElegantPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.impl.Config;
import hohserg.elegant.networking.impl.IPacketProvider;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.Registry;
import hohserg.elegant.networking.impl.SerializerMark;
import hohserg.elegant.networking.utils.PrintUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.tuple.Pair;

public class Init {
    private final Consumer<String> msgPrintln;
    private final Consumer<String> errorPrintln;
    private final Consumer<String> channelNameConsumer;
    private final PrintWriter errorWriter;

    public static Config initConfig(File configFolder) {
        File configFile = new File(configFolder, "elegant_networking.cfg");
        Config config = new Config();
        if (configFile.exists()) {
            Init.loadConfig(configFile, config);
        } else {
            Init.saveDefaultConfig(configFile, config);
        }
        return config;
    }

    private static void saveDefaultConfig(File configFile, Config config) {
        try (FileWriter fileWriter = new FileWriter(configFile);){
            fileWriter.write("# How many bytes can contains received packet\n");
            fileWriter.write("packetSizeLimit = " + config.packetSizeLimit + "\n");
            fileWriter.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File configFile, Config config) {
        try (FileInputStream fileInputStream = new FileInputStream(configFile);
             Scanner s = new Scanner(fileInputStream);){
            while (s.hasNextLine()) {
                String[] split;
                String line;
                int commentStart = (line = s.nextLine()).indexOf(35);
                String withoutComment = line.substring(0, commentStart == -1 ? line.length() : commentStart);
                if (withoutComment.isEmpty() || (split = withoutComment.split("=")).length != 2) continue;
                String fieldName = split[0].trim();
                String value = split[1].trim();
                if (!fieldName.equals("packetSizeLimit")) continue;
                config.packetSizeLimit = Integer.parseInt(value);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initPackets(Consumer<String> msgPrintln, Consumer<String> errorPrintln, Consumer<String> channelNameConsumer) {
        new Init(msgPrintln, errorPrintln, channelNameConsumer).registerAllPackets();
    }

    private Init(Consumer<String> msgPrintln, Consumer<String> errorPrintln, Consumer<String> channelNameConsumer) {
        this.msgPrintln = msgPrintln;
        this.errorPrintln = errorPrintln;
        this.channelNameConsumer = channelNameConsumer;
        this.errorWriter = PrintUtils.getWriterForStringConsumer(errorPrintln);
    }

    private void registerAllPackets() {
        this.safeIterator(ServiceLoader.load(ISerializerBase.class).iterator(), "Trouble while indexing serializers").forEachRemaining(serializer -> Registry.registerSerializer(Init.getPacketClass(serializer), serializer));
        Map channelToPackets = StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.safeIterator(ServiceLoader.load(IPacketProvider.class).iterator(), "Trouble while indexing elegant packets:"), 16), false).flatMap(this.safeMapper(packetProvider -> Pair.of((Object)Init.getPacketChannel(packetProvider), packetProvider.getPacketClass()), "Trouble while indexing elegant packets:")).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        channelToPackets.forEach((channel, packets) -> {
            this.printStarted((String)channel);
            try {
                for (int i = 0; i < packets.size(); ++i) {
                    Class packetClass = (Class)packets.get(i);
                    int packetId = i + 1;
                    Registry.register(channel, packetId, packetClass.getCanonicalName());
                    this.printRegistered((String)channel, packetClass, packetId);
                }
                this.channelNameConsumer.accept((String)channel);
                this.printSuccessfully((String)channel);
            }
            catch (Throwable e) {
                this.printFailed((String)channel, e);
            }
        });
    }

    private void printStarted(String channel) {
        this.msgPrintln.accept("Starting registration of elegant packets for channel " + channel);
    }

    private void printRegistered(String channel, Class<? extends IByteBufSerializable> packetClass, int packetId) {
        this.msgPrintln.accept("Registered packet " + packetClass.getSimpleName() + " for channel " + channel + " with id " + packetId);
    }

    private void printSuccessfully(String channel) {
        this.msgPrintln.accept("Successfully registered packets for channel " + channel);
    }

    private void printFailed(String channel, Throwable e) {
        this.printError(e, "Failed to register packets for channel " + channel + "\nCaused by:");
    }

    private <A> Iterator<A> safeIterator(Iterator<A> iterator, String errorPrefix) {
        LinkedList<A> content = new LinkedList<A>();
        while (iterator.hasNext()) {
            try {
                content.add(iterator.next());
            }
            catch (Throwable e) {
                this.printError(e, errorPrefix);
            }
        }
        return content.iterator();
    }

    private <A, B> Function<A, Stream<B>> safeMapper(Function<A, B> f, String errorPrefix) {
        return a -> {
            try {
                return Stream.of(f.apply(a));
            }
            catch (Throwable e) {
                this.printError(e, errorPrefix);
                return Stream.empty();
            }
        };
    }

    private void printError(Throwable e, String errorPrefix) {
        this.errorPrintln.accept(errorPrefix);
        e.printStackTrace(this.errorWriter);
        this.errorWriter.flush();
    }

    private static String getPacketChannel(IPacketProvider packetProvider) {
        String annotatedChannel = Objects.requireNonNull(packetProvider.getPacketClass().getAnnotation(ElegantPacket.class)).channel();
        return annotatedChannel.equals("$modid") ? packetProvider.modid() : annotatedChannel;
    }

    private static Class<? extends IByteBufSerializable> getPacketClass(ISerializerBase serializer) {
        return serializer.getClass().getAnnotation(SerializerMark.class).packetClass();
    }
}

