/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.ISerializerBase;
import hohserg.elegant.networking.impl.Network;
import hohserg.elegant.networking.impl.Registry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class CCLNetworkImpl
implements Network<PacketCustom> {
    @Override
    public void sendToPlayer(ServerToClientPacket serverToClientPacket, EntityPlayerMP player) {
        this.preparePacket(serverToClientPacket).sendToPlayer((EntityPlayer)player);
    }

    @Override
    public void sendToClients(ServerToClientPacket serverToClientPacket) {
        this.preparePacket(serverToClientPacket).sendToClients();
    }

    @Override
    public void sendPacketToAllAround(ServerToClientPacket serverToClientPacket, World world, double x, double y, double z, double range) {
        this.preparePacket(serverToClientPacket).sendPacketToAllAround(x, y, z, range, world.field_73011_w.getDimension());
    }

    @Override
    public void sendToDimension(ServerToClientPacket serverToClientPacket, World world) {
        this.preparePacket(serverToClientPacket).sendToDimension(world.field_73011_w.getDimension());
    }

    @Override
    public void sendToChunk(ServerToClientPacket serverToClientPacket, World world, int chunkX, int chunkZ) {
        this.preparePacket(serverToClientPacket).sendToChunk(world, chunkX, chunkZ);
    }

    @Override
    public void sendToServer(ClientToServerPacket packet) {
        this.preparePacket(packet).sendToServer();
    }

    private PacketCustom preparePacket(IByteBufSerializable packet) {
        this.checkSendingSide(packet);
        String packetClassName = packet.getClass().getName();
        ISerializerBase serializer = Registry.getSerializer(packetClassName);
        String channel = Registry.getChannelForPacket(packetClassName);
        Integer id = Registry.getPacketId(packetClassName);
        PacketCustom packetCustom = new PacketCustom((Object)channel, id.intValue());
        ByteBuf buffer = Unpooled.buffer();
        serializer.serialize(packet, buffer);
        packetCustom.writeShort(buffer.readableBytes());
        packetCustom.writeBytes(buffer);
        return packetCustom;
    }

    @Override
    public void onReceiveClient(PacketCustom packetRepresent, String channel) {
        ((ServerToClientPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(Minecraft.func_71410_x());
    }

    @Override
    public void onReceiveServer(PacketCustom packetRepresent, EntityPlayerMP player, String channel) {
        ((ClientToServerPacket)this.readObjectFromPacket(packetRepresent, channel)).onReceive(player);
    }

    private <A> A readObjectFromPacket(PacketCustom packetRepresent, String channel) {
        short size = packetRepresent.readShort();
        ByteBuf buffer = Unpooled.buffer((int)size);
        packetRepresent.readBytes(buffer, (int)size);
        return Registry.getSerializer(Registry.getPacketName(channel, packetRepresent.getType())).unserialize(buffer);
    }

    @Override
    public void registerChannel(String channel) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            PacketCustom.assignHandler((Object)channel, (ICustomPacketHandler)((ICustomPacketHandler.IClientPacketHandler)(packet, mc, handler) -> this.onReceiveClient(packet, channel)));
        }
        PacketCustom.assignHandler((Object)channel, (ICustomPacketHandler)((ICustomPacketHandler.IServerPacketHandler)(packet, sender, handler) -> this.onReceiveServer(packet, sender, channel)));
    }
}

