/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.api.ClientToServerPacket;
import hohserg.elegant.networking.api.IByteBufSerializable;
import hohserg.elegant.networking.api.ServerToClientPacket;
import hohserg.elegant.networking.impl.ElegantNetworking;
import hohserg.elegant.networking.impl.Network;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeNetworkImpl2
implements Network<ByteBuf> {
    private Map<String, FMLEventChannel> channels = new HashMap<String, FMLEventChannel>();

    @Override
    public void sendToPlayer(ServerToClientPacket serverToClientPacket, EntityPlayerMP player) {
        this.getChannel(serverToClientPacket).sendTo(this.preparePacket(serverToClientPacket), player);
    }

    @Override
    public void sendToClients(ServerToClientPacket serverToClientPacket) {
        this.getChannel(serverToClientPacket).sendToAll(this.preparePacket(serverToClientPacket));
    }

    @Override
    public void sendPacketToAllAround(ServerToClientPacket serverToClientPacket, World world, double x, double y, double z, double range) {
        this.getChannel(serverToClientPacket).sendToAllAround(this.preparePacket(serverToClientPacket), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), x, y, z, range));
    }

    @Override
    public void sendToDimension(ServerToClientPacket serverToClientPacket, World world) {
        this.getChannel(serverToClientPacket).sendToDimension(this.preparePacket(serverToClientPacket), world.field_73011_w.getDimension());
    }

    @Override
    public void sendToChunk(ServerToClientPacket serverToClientPacket, World world, int chunkX, int chunkZ) {
        this.getChannel(serverToClientPacket).sendToAllAround(this.preparePacket(serverToClientPacket), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)(chunkX << 4), 0.0, (double)(chunkZ << 4), 256.0));
    }

    private FMLProxyPacket preparePacket(IByteBufSerializable serverToClientPacket) {
        String name = serverToClientPacket.getClass().getName();
        ByteBuf acc = Unpooled.buffer();
        ElegantNetworking.getSerializer(name).serialize(serverToClientPacket, acc);
        return new FMLProxyPacket(new PacketBuffer(acc), ElegantNetworking.getChannelForPacket(name));
    }

    @Override
    public void sendToServer(ClientToServerPacket packet) {
        this.getChannel(packet).sendToServer(this.preparePacket(packet));
    }

    private FMLEventChannel getChannel(IByteBufSerializable serverToClientPacket) {
        return this.channels.get(ElegantNetworking.getChannelForPacket(serverToClientPacket.getClass().getName()));
    }

    @Override
    public void onReceiveClient(ByteBuf packetRepresent, String channel) {
        byte id = packetRepresent.readByte();
        ((ServerToClientPacket)ElegantNetworking.getSerializer(ElegantNetworking.getPacketName(channel, id)).unserialize(packetRepresent)).onReceive(Minecraft.func_71410_x());
    }

    @Override
    public void onReceiveServer(ByteBuf packetRepresent, EntityPlayerMP player, String channel) {
        byte id = packetRepresent.readByte();
        ((ClientToServerPacket)ElegantNetworking.getSerializer(ElegantNetworking.getPacketName(channel, id)).unserialize(packetRepresent)).onReceive(player);
    }

    @Override
    public void registerChannel(final String channel) {
        FMLEventChannel fmlEventChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channel);
        this.channels.put(channel, fmlEventChannel);
        fmlEventChannel.register(new Object(){

            @SubscribeEvent
            @SideOnly(value=Side.CLIENT)
            public void onClientReceive(FMLNetworkEvent.ClientCustomPacketEvent e) {
                ForgeNetworkImpl2.this.onReceiveClient(e.getPacket().payload(), channel);
            }

            @SubscribeEvent
            @SideOnly(value=Side.SERVER)
            public void onServerReceive(FMLNetworkEvent.ServerCustomPacketEvent e) {
                ForgeNetworkImpl2.this.onReceiveServer(e.getPacket().payload(), ((NetHandlerPlayServer)e.getHandler()).field_147369_b, channel);
            }
        });
    }
}

