/*
 * Decompiled with CFR 0.152.
 */
package hohserg.elegant.networking.impl;

import hohserg.elegant.networking.impl.CCLNetworkImpl;
import hohserg.elegant.networking.impl.ForgeNetworkImpl;
import hohserg.elegant.networking.impl.ISerializer;
import hohserg.elegant.networking.impl.Network;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;

public class ElegantNetworking {
    private static Map<String, String> channelByPacketClassName = new HashMap<String, String>();
    private static Map<String, Integer> packetIdByPacketClassName = new HashMap<String, Integer>();
    private static Map<Pair<String, Integer>, String> packetClassNameByChannelId = new HashMap<Pair<String, Integer>, String>();
    private static Map<String, ISerializer> serializerByPacketClassName = new HashMap<String, ISerializer>();
    private static Network defaultImpl = Loader.isModLoaded((String)"codechickenlib") ? new CCLNetworkImpl() : new ForgeNetworkImpl();

    static String getChannelForPacket(String className) {
        return channelByPacketClassName.get(className);
    }

    static List<String> getPacketsForChannel(String channel) {
        return channelByPacketClassName.entrySet().stream().filter(i -> ((String)i.getValue()).equals(channel)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static int getPacketId(String className) {
        return packetIdByPacketClassName.get(className);
    }

    static String getPacketName(String channel, int id) {
        return packetClassNameByChannelId.get(Pair.of((Object)channel, (Object)id));
    }

    static ISerializer getSerializer(String className) {
        return serializerByPacketClassName.get(className);
    }

    public static Network getNetwork() {
        return defaultImpl;
    }

    static void register(PacketInfo p, ISerializer serializer) {
        int id = serializer.packetId();
        channelByPacketClassName.put(p.className, p.channel);
        packetIdByPacketClassName.put(p.className, id);
        packetClassNameByChannelId.put((Pair<String, Integer>)Pair.of((Object)p.channel, (Object)id), p.className);
        serializerByPacketClassName.put(p.className, serializer);
    }

    static final class PacketInfo {
        public final String channel;
        public final String className;

        public PacketInfo(String channel, String className) {
            this.channel = channel;
            this.className = className;
        }

        public String getChannel() {
            return this.channel;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PacketInfo)) {
                return false;
            }
            PacketInfo other = (PacketInfo)o;
            String this$channel = this.getChannel();
            String other$channel = other.getChannel();
            if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $channel = this.getChannel();
            result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "ElegantNetworking.PacketInfo(channel=" + this.getChannel() + ", className=" + this.getClassName() + ")";
        }
    }
}

