package io.gitlab.guiVista.core

import glib2.*
import kotlinx.cinterop.CValue
import kotlinx.cinterop.toKString

public actual interface ValueBase : Closable {
    public val gValue: CValue<GValue>?

    public actual fun changeString(newValue: String) {
        g_value_set_string(gValue, newValue)
    }

    public actual fun changeStaticString(newValue: String) {
        g_value_set_static_string(gValue, newValue)
    }

    public actual fun changeBoolean(newValue: Boolean) {
        g_value_set_boolean(gValue, if (newValue) TRUE else FALSE)
    }

    public actual fun changeStaticChar(newValue: Char) {
        g_value_set_schar(gValue, newValue.toByte())
    }

    public actual fun changeDouble(newValue: Double) {
        g_value_set_double(gValue, newValue)
    }

    public actual fun changeFloat(newValue: Float) {
        g_value_set_float(gValue, newValue)
    }

    public actual fun changeGType(newValue: ULong) {
        g_value_set_gtype(gValue, newValue)
    }

    public actual fun changeInt(newValue: Int) {
        g_value_set_int(gValue, newValue)
    }

    public actual fun changeLong(newValue: Long) {
        g_value_set_long(gValue, newValue)
    }

    public actual fun changeObject(newValue: Object?) {
        g_value_set_object(gValue, newValue?.objPtr)
    }

    public actual fun changeUByte(newValue: UByte) {
        g_value_set_uchar(gValue, newValue)
    }

    public actual fun changeUInt(newValue: UInt) {
        g_value_set_uint(gValue, newValue)
    }

    public actual fun changeULong(newValue: ULong) {
        g_value_set_ulong(gValue, newValue)
    }

    public fun changePointer(newValue: gpointer?) {
        g_value_set_pointer(gValue, newValue)
    }

    public actual fun fetchString(): String = g_value_get_string(gValue)?.toKString() ?: ""

    public actual fun fetchBoolean(): Boolean = g_value_get_boolean(gValue) == TRUE

    public actual fun fetchChar(): Char = g_value_get_char(gValue).toChar()

    public actual fun fetchDouble(): Double = g_value_get_double(gValue)

    public actual fun fetchFloat(): Float = g_value_get_float(gValue)

    public actual fun fetchGType(): ULong = g_value_get_gtype(gValue)

    public actual fun fetchInt(): Int = g_value_get_int(gValue)

    public actual fun fetchLong(): Long = g_value_get_long(gValue)

    public actual fun fetchObject(): Object = Object.fromPointer(g_value_get_object(gValue))

    public actual fun fetchUByte(): UByte = g_value_get_uchar(gValue)

    public actual fun fetchUInt(): UInt = g_value_get_uint(gValue)

    public actual fun fetchULong(): ULong = g_value_get_ulong(gValue)

    public fun fetchPointer(): gpointer? = g_value_get_pointer(gValue)

    override fun close() {
        g_value_unset(gValue)
    }
}
