/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.utils;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.utils.ModelUtils;
import io.github.robwin.swagger2markup.utils.PropertyUtils;
import io.swagger.models.Model;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public final class ParameterUtils {
    public static String getType(Parameter parameter, MarkupLanguage markupLanguage) {
        Validate.notNull((Object)parameter, (String)"property must not be null!", (Object[])new Object[0]);
        String type = "NOT FOUND";
        if (parameter instanceof BodyParameter) {
            BodyParameter bodyParameter = (BodyParameter)parameter;
            Model model = bodyParameter.getSchema();
            type = model != null ? ModelUtils.getType(model, markupLanguage) : "string";
        } else if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)parameter;
            List enums = serializableParameter.getEnum();
            type = CollectionUtils.isNotEmpty((Collection)enums) ? "enum (" + StringUtils.join((Iterable)enums, (String)", ") + ")" : ParameterUtils.getTypeWithFormat(serializableParameter.getType(), serializableParameter.getFormat());
            if (type.equals("array")) {
                String collectionFormat = serializableParameter.getCollectionFormat();
                type = collectionFormat + " " + PropertyUtils.getType(serializableParameter.getItems(), markupLanguage) + " " + type;
            }
        } else if (parameter instanceof RefParameter) {
            RefParameter refParameter = (RefParameter)parameter;
            switch (markupLanguage) {
                case ASCIIDOC: {
                    return "<<" + refParameter.getSimpleRef() + ">>";
                }
            }
            return refParameter.getSimpleRef();
        }
        return StringUtils.defaultString((String)type);
    }

    private static String getTypeWithFormat(String typeWithoutFormat, String format) {
        String type = StringUtils.isNotBlank((CharSequence)format) ? StringUtils.defaultString((String)typeWithoutFormat) + " (" + format + ")" : StringUtils.defaultString((String)typeWithoutFormat);
        return type;
    }

    public static String getDefaultValue(Parameter parameter) {
        Validate.notNull((Object)parameter, (String)"property must not be null!", (Object[])new Object[0]);
        String defaultValue = "";
        if (parameter instanceof AbstractSerializableParameter) {
            AbstractSerializableParameter serializableParameter = (AbstractSerializableParameter)parameter;
            defaultValue = serializableParameter.getDefaultValue();
        }
        return StringUtils.defaultString((String)defaultValue);
    }
}

