/*
 * Decompiled with CFR 0.152.
 */
package io.github.perplexhub.rsql;

import jakarta.persistence.criteria.Expression;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ResolvedExpression {
    public static ResolvedExpression ofPath(Expression<?> expression, Class<?> type) {
        return new PathExpression(expression, type);
    }

    public static ResolvedExpression ofJson(Expression<Boolean> expression, boolean inverted) {
        return new JsonbPathExpression(expression, inverted);
    }

    public record PathExpression(Expression<?> expression, Class<?> type) implements ResolvedExpression
    {
        public PathExpression {
            if (expression == null) {
                throw new IllegalArgumentException("Expression cannot be null");
            }
            if (type == null) {
                throw new IllegalArgumentException("Type cannot be null");
            }
        }
    }

    public record JsonbPathExpression(Expression<Boolean> expression, boolean inverted) implements ResolvedExpression
    {
        public JsonbPathExpression {
            if (expression == null) {
                throw new IllegalArgumentException("Expression cannot be null");
            }
        }
    }
}

