/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.AbstractNode;
import cz.jirutka.rsql.parser.ast.Assert;
import cz.jirutka.rsql.parser.ast.LogicalOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class LogicalNode
extends AbstractNode
implements Iterable<Node> {
    private final List<Node> children;
    private final LogicalOperator operator;

    protected LogicalNode(LogicalOperator operator, List<? extends Node> children) {
        Assert.notNull((Object)operator, "operator must not be null", new Object[0]);
        Assert.notNull(children, "children must not be null", new Object[0]);
        this.operator = operator;
        this.children = Collections.unmodifiableList(new ArrayList<Node>(children));
    }

    public abstract LogicalNode withChildren(List<? extends Node> var1);

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public List<Node> getChildren() {
        return new ArrayList<Node>(this.children);
    }

    public String toString() {
        return StringUtils.join(this.children, this.operator.toString(), "(", ")");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogicalNode)) {
            return false;
        }
        LogicalNode nodes = (LogicalNode)o;
        return this.children.equals(nodes.children) && this.operator == nodes.operator;
    }

    public int hashCode() {
        int result = this.children.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }
}

