/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.AbstractNode;
import cz.jirutka.rsql.parser.ast.Arity;
import cz.jirutka.rsql.parser.ast.Assert;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class ComparisonNode
extends AbstractNode {
    private final ComparisonOperator operator;
    private final String selector;
    private final List<String> arguments;

    public ComparisonNode(ComparisonOperator operator, String selector, List<String> arguments) {
        this(operator, selector, new ArrayList<String>(arguments), true);
    }

    ComparisonNode(ComparisonOperator operator, String selector, List<String> arguments, boolean trusted) {
        Assert.notNull(operator, "operator must not be null", new Object[0]);
        Assert.notBlank(selector, "selector must not be blank", new Object[0]);
        Assert.notNull(arguments, "arguments must not be null", new Object[0]);
        ComparisonNode.validate(operator, arguments.size());
        this.operator = operator;
        this.selector = selector;
        this.arguments = arguments;
    }

    @Override
    public <R, A> R accept(RSQLVisitor<R, A> visitor, A param) {
        return visitor.visit(this, param);
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public ComparisonNode withOperator(ComparisonOperator newOperator) {
        return new ComparisonNode(newOperator, this.selector, this.arguments, true);
    }

    public String getSelector() {
        return this.selector;
    }

    public ComparisonNode withSelector(String newSelector) {
        return this.selector.equals(newSelector) ? this : new ComparisonNode(this.operator, newSelector, this.arguments, true);
    }

    public List<String> getArguments() {
        return new ArrayList<String>(this.arguments);
    }

    public ComparisonNode withArguments(List<String> newArguments) {
        return new ComparisonNode(this.operator, this.selector, newArguments);
    }

    private static void validate(ComparisonOperator operator, int argc) {
        Arity arity = operator.getArity();
        int min = arity.min();
        int max = arity.max();
        if (argc < min || argc > max) {
            String message = min == max ? String.format("operator '%s' can have exactly %d argument(s), but got %d", operator.getSymbol(), max, argc) : String.format("operator '%s' can have from %d to %d argument(s), but got %d", operator.getSymbol(), min, max, argc);
            throw new IllegalArgumentException(message);
        }
    }

    public String toString() {
        Arity arity = this.operator.getArity();
        String args = arity.max() > 1 ? StringUtils.join(this.arguments, "','", "('", "')", "()") : (!this.arguments.isEmpty() ? "'" + this.arguments.get(0) + "'" : "");
        return this.selector + this.operator + args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonNode)) {
            return false;
        }
        ComparisonNode that = (ComparisonNode)o;
        return this.arguments.equals(that.arguments) && this.operator.equals(that.operator) && this.selector.equals(that.selector);
    }

    public int hashCode() {
        int result = this.selector.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }
}

