/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser;

import cz.jirutka.rsql.parser.Parser;
import cz.jirutka.rsql.parser.RSQLParserException;
import cz.jirutka.rsql.parser.TokenMgrError;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.NodesFactory;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.io.StringReader;
import java.util.Set;
import net.jcip.annotations.Immutable;

@Immutable
public final class RSQLParser {
    private final NodesFactory nodesFactory;

    public RSQLParser() {
        this(RSQLOperators.defaultOperators());
    }

    public RSQLParser(Set<ComparisonOperator> operators) {
        this(new NodesFactory(operators));
    }

    public RSQLParser(NodesFactory nodesFactory) {
        if (nodesFactory == null) {
            throw new IllegalArgumentException("nodesFactory must not be null");
        }
        this.nodesFactory = nodesFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parse(String query) throws RSQLParserException {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        try (StringReader reader = new StringReader(query);){
            Parser parser = new Parser(reader, this.nodesFactory);
            Node node = parser.Input();
            return node;
        }
        catch (TokenMgrError | Exception ex) {
            throw new RSQLParserException(ex);
        }
    }
}

