/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.jpa.conversion.serializer;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.zhucan.jpa.conversion.serializer.JsonEnumDeserializer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class JsonEnumConverter
implements ApplicationListener<ContextRefreshedEvent> {
    @Autowired
    private MappingJackson2HttpMessageConverter httpMessageConverter;
    @Autowired
    private ObjectMapper objectMapper;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.httpMessageConverter != null) {
            this.objectMapper = this.httpMessageConverter.getObjectMapper();
        }
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(Enum.class, (JsonDeserializer)new JsonEnumDeserializer());
        this.objectMapper.registerModule((Module)simpleModule);
        this.httpMessageConverter.setObjectMapper(this.objectMapper);
    }

    @ConditionalOnMissingBean(value={MappingJackson2HttpMessageConverter.class})
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter() {
        return new MappingJackson2HttpMessageConverter();
    }
}

