/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.jpa.conversion.processor;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.zhucan.jpa.conversion.annotation.EnumAutoConverter;
import com.zhucan.jpa.conversion.converter.AbstractEnumConverter;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.persistence.Converter;
import javax.tools.Diagnostic;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"com.zhucan.jpa.conversion.annotation.EnumAutoConverter"})
@AutoService(value=Processor.class)
public class EnumConvertProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Elements elementUtils;
    public static final String doc = "\n This codes are generated automatically. Do not modify! \n -.- \n created by zhuCan \n";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = this.processingEnv.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.elementUtils = processingEnvironment.getElementUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processor : " + this.getClass().getSimpleName());
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(EnumAutoConverter.class);
        this.messager.printMessage(Diagnostic.Kind.NOTE, "annotations: " + annotations);
        this.messager.printMessage(Diagnostic.Kind.NOTE, "roundEnv: " + roundEnv);
        elements.forEach(x -> {
            PackageElement packageElement = this.elementUtils.getPackageOf((Element)x);
            String packageName = packageElement.getQualifiedName().toString();
            EnumAutoConverter annotation = x.getAnnotation(EnumAutoConverter.class);
            TypeSpec clazz = TypeSpec.classBuilder((String)(x.getSimpleName() + "Converter")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder(Converter.class).addMember("autoApply", CodeBlock.builder().add("$L", new Object[]{annotation.autoApply()}).build()).build()).addJavadoc(" generator for enum converter \n This codes are generated automatically. Do not modify! \n -.- \n created by zhuCan \n", new Object[0]).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(AbstractEnumConverter.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)((TypeElement)x)), ClassName.get(Integer.class)})).build();
            try {
                JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)clazz).build();
                javaFile.writeTo(this.filer);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return false;
    }
}

