/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.jpa.conversion.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.persistence.AttributeConverter;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractJsonConverter<T>
implements AttributeConverter<T, String> {
    protected static ObjectMapper objectMapper;

    @Autowired
    public void setObjectMapper(ObjectMapper objectMapper) {
        AbstractJsonConverter.objectMapper = objectMapper;
    }

    public String convertToDatabaseColumn(T attribute) {
        objectMapper.setConfig(objectMapper.getSerializationConfig().without(SerializationFeature.FAIL_ON_EMPTY_BEANS));
        ObjectWriter writer = objectMapper.writerFor(this.getJsonType());
        try {
            return writer.writeValueAsString(attribute);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public T convertToEntityAttribute(String dbData) {
        ObjectReader reader = objectMapper.readerFor(this.getJsonType());
        try {
            return (T)(dbData == null ? null : reader.readValue(dbData));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected TypeReference<T> getJsonType() {
        final Type[] actualTypeArguments = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        if (actualTypeArguments != null && actualTypeArguments.length > 0) {
            return new TypeReference<T>(){

                public Type getType() {
                    return actualTypeArguments[0];
                }
            };
        }
        return null;
    }
}

