/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.jpa.conversion.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.zhucan.jpa.conversion.CodeEnum;
import java.io.IOException;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class JsonEnumDeserializer
extends JsonDeserializer<Enum<?>>
implements ContextualDeserializer {
    private Class clazz;

    public Enum<?> deserialize(JsonParser p, DeserializationContext context) throws IOException {
        if (!StringUtils.isEmpty((Object)p.getText()) && CodeEnum.class.isAssignableFrom(this.clazz) && JsonEnumDeserializer.isInteger(p.getText())) {
            return (Enum)CodeEnum.valueOf(this.clazz, Integer.valueOf(p.getText()));
        }
        return null;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty property) {
        Class rawCls = context.getContextualType().getRawClass();
        JsonEnumDeserializer clone = new JsonEnumDeserializer();
        clone.setClazz(rawCls);
        return clone;
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-\\+]?[\\d]*$");
        return pattern.matcher(str).matches();
    }

    public Class getClazz() {
        return this.clazz;
    }

    public void setClazz(Class clazz) {
        this.clazz = clazz;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonEnumDeserializer)) {
            return false;
        }
        JsonEnumDeserializer other = (JsonEnumDeserializer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Class this$clazz = this.getClazz();
        Class other$clazz = other.getClazz();
        return !(this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonEnumDeserializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class $clazz = this.getClazz();
        result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
        return result;
    }

    public String toString() {
        return "JsonEnumDeserializer(clazz=" + this.getClazz() + ")";
    }
}

