/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.enums.scanner.handler;

import com.zhucan.enums.scanner.CodeEnum;
import com.zhucan.enums.scanner.annotation.EnumScan;
import com.zhucan.enums.scanner.cached.EnumCache;
import com.zhucan.enums.scanner.context.ResourcesScanner;
import com.zhucan.enums.scanner.dto.CodeItem;
import com.zhucan.enums.scanner.dto.CodeTable;
import com.zhucan.enums.scanner.handler.EnumScanHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnumScanHandlerImpl
implements EnumScanHandler {
    private EnumCache cache;
    private ResourcesScanner<Class<?>> resourcesScanner;

    public EnumScanHandlerImpl(EnumCache cache, ResourcesScanner<Class<?>> resourcesScanner) {
        this.cache = cache;
        this.resourcesScanner = resourcesScanner;
    }

    private void cacheHandler() {
        List<Class<?>> classes = this.resourcesScanner.classScan();
        ArrayList<CodeTable> codeEnums = new ArrayList<CodeTable>();
        classes.forEach(clazz -> {
            try {
                if (CodeEnum.class.isAssignableFrom((Class<?>)clazz) && clazz.isEnum() && clazz.isAnnotationPresent(EnumScan.class)) {
                    List items = Arrays.stream(clazz.getEnumConstants()).map(item -> (CodeEnum)item).collect(Collectors.toList());
                    int defaultEnumCode = clazz.getAnnotation(EnumScan.class).defaultEnumCode();
                    codeEnums.add(new CodeTable(clazz.getSimpleName(), items.stream().map(CodeItem::new).collect(Collectors.toList()), items.stream().collect(Collectors.toMap(CodeEnum::code, i -> i, (m, n) -> m)).get(defaultEnumCode), clazz.getName()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.cache.write(codeEnums);
    }

    @Override
    public List<CodeTable> codeTables() {
        List<CodeTable> read = this.cache.read();
        if (read == null) {
            this.cacheHandler();
            return this.cache.read();
        }
        return read;
    }
}

