/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.enums.scanner.context;

import com.zhucan.enums.scanner.context.EnumScanProperties;
import com.zhucan.enums.scanner.context.ResourcesScanner;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotationMetadata;

public class ExtensionClassPathScanningCandidateComponentProvider
extends ClassPathScanningCandidateComponentProvider
implements ResourcesScanner<Class<?>> {
    private final Logger log = LoggerFactory.getLogger(ExtensionClassPathScanningCandidateComponentProvider.class);
    private final EnumScanProperties properties;
    private ApplicationContext context;

    public ExtensionClassPathScanningCandidateComponentProvider(boolean useDefaultFilters, Consumer<ExtensionClassPathScanningCandidateComponentProvider> consumer, EnumScanProperties properties, ApplicationContext context) {
        super(useDefaultFilters);
        this.properties = properties;
        this.context = context;
        consumer.accept(this);
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        AnnotationMetadata metadata = beanDefinition.getMetadata();
        return metadata.isIndependent();
    }

    @Override
    public List<Class<?>> classScan() {
        HashSet candidateComponents = new HashSet();
        this.setResourceLoader((ResourceLoader)this.context);
        this.properties.getScanPackages().forEach(x -> candidateComponents.addAll(this.findCandidateComponents((String)x)));
        return candidateComponents.stream().map(x -> {
            try {
                return Class.forName(x.getBeanClassName());
            }
            catch (ClassNotFoundException e) {
                this.log.error("\u626b\u63cf\u8d44\u6e90, \u6267\u884c class \u52a0\u8f7d\u5f02\u5e38", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

