/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.enums.scanner;

import com.google.common.collect.Lists;
import com.zhucan.enums.scanner.annotation.EnumScan;
import com.zhucan.enums.scanner.cached.EnumCache;
import com.zhucan.enums.scanner.cached.MemoryEnumCache;
import com.zhucan.enums.scanner.context.EnumScanProperties;
import com.zhucan.enums.scanner.context.ExtensionClassPathScanningCandidateComponentProvider;
import com.zhucan.enums.scanner.context.ResourcesScanner;
import com.zhucan.enums.scanner.context.TypeFilterProvider;
import com.zhucan.enums.scanner.handler.EnumScanHandler;
import com.zhucan.enums.scanner.handler.EnumScanHandlerImpl;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

@EnableConfigurationProperties(value={EnumScanProperties.class})
@Configuration
public class CodeEnumAutoConfiguration {
    @Bean
    public EnumScanHandler enumTable(EnumCache cache, ResourcesScanner<Class<?>> scanner) {
        return new EnumScanHandlerImpl(cache, scanner);
    }

    @Bean
    @ConditionalOnMissingBean(value={EnumCache.class})
    public EnumCache enumCache() {
        return new MemoryEnumCache();
    }

    @Bean
    @ConditionalOnMissingBean(value={ResourcesScanner.class})
    public ResourcesScanner<Class<?>> resourcesScanner(EnumScanProperties properties, TypeFilterProvider typeFilterProvider, ApplicationContext context) {
        return new ExtensionClassPathScanningCandidateComponentProvider(false, x -> {
            List<TypeFilter> filters = typeFilterProvider.filter();
            if (filters != null) {
                filters.forEach(arg_0 -> ((ExtensionClassPathScanningCandidateComponentProvider)x).addIncludeFilter(arg_0));
            }
        }, properties, context);
    }

    @Bean
    @ConditionalOnMissingBean(value={TypeFilterProvider.class})
    public TypeFilterProvider typeFilterProvider() {
        return () -> Lists.newArrayList((Object[])new TypeFilter[]{new AnnotationTypeFilter(EnumScan.class)});
    }
}

