/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.enums.scanner.handler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zhucan.enums.scanner.CodeEnum;
import com.zhucan.enums.scanner.annotation.EnumScan;
import com.zhucan.enums.scanner.cached.EnumCache;
import com.zhucan.enums.scanner.dto.CodeItem;
import com.zhucan.enums.scanner.dto.CodeTable;
import com.zhucan.enums.scanner.handler.EnumScanHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ResourceUtils;

public class EnumScanHandlerImpl
implements EnumScanHandler {
    @Autowired
    private EnumCache cache;
    @Autowired
    private ObjectMapper mapper;

    private void cacheHandler() throws IOException {
        List<Object> classes = new ArrayList();
        try {
            File file = ResourceUtils.getFile((String)"classpath:enum_classpath_cached");
            List classPath = (List)this.mapper.readValue(file, (TypeReference)new TypeReference<List<String>>(){

                public Type getType() {
                    return super.getType();
                }
            });
            classes = classPath.stream().map(x -> {
                try {
                    return Class.forName(x);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        ArrayList<CodeTable> codeEnums = new ArrayList<CodeTable>();
        classes.forEach(clazz -> {
            try {
                if (CodeEnum.class.isAssignableFrom((Class<?>)clazz) && clazz.isEnum() && clazz.isAnnotationPresent(EnumScan.class)) {
                    List items = Arrays.stream(clazz.getEnumConstants()).map(item -> (CodeEnum)item).collect(Collectors.toList());
                    int defaultEnumCode = clazz.getAnnotation(EnumScan.class).defaultEnumCode();
                    codeEnums.add(CodeTable.builder().items(items.stream().map(CodeItem::new).collect(Collectors.toList())).enumName(clazz.getSimpleName()).classPath(clazz.getName()).defaultItem(items.stream().collect(Collectors.toMap(CodeEnum::code, i -> i, (m, n) -> m)).get(defaultEnumCode)).build());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.cache.write(codeEnums);
    }

    @Override
    public List<CodeTable> codeTables() {
        List<CodeTable> read = this.cache.read();
        if (read == null) {
            try {
                this.cacheHandler();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.cache.read();
        }
        return read;
    }
}

