/*
 * Decompiled with CFR 0.152.
 */
package com.zhucan.enums.scanner.annotation.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.service.AutoService;
import com.zhucan.enums.scanner.annotation.EnumScan;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@AutoService(value=Processor.class)
public class EnumScannerProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Elements elementUtils;
    private ObjectMapper mapper;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = this.processingEnv.getFiler();
        this.messager = processingEnvironment.getMessager();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.mapper = new ObjectMapper();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(EnumScan.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.messager.printMessage(Diagnostic.Kind.NOTE, "Processor : " + this.getClass().getSimpleName());
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "found @Log at " + element);
            }
        }
        Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(EnumScan.class);
        ArrayList arrayList = new ArrayList();
        elements.forEach(x -> {
            PackageElement packageElement = this.elementUtils.getPackageOf((Element)x);
            String packageName = packageElement.getQualifiedName().toString();
            Name simpleName = x.getSimpleName();
            clazz.add(packageName + "." + simpleName);
        });
        try {
            if (!elements.isEmpty()) {
                FileObject resource = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "enum_classpath_cached", new Element[0]);
                Writer writer = resource.openWriter();
                writer.write(this.mapper.writeValueAsString(arrayList));
                writer.flush();
                writer.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.messager.printMessage(Diagnostic.Kind.ERROR, "mistake : " + e.getLocalizedMessage());
        }
        return false;
    }
}

