/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhucan123.ons.producer;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import io.gitee.zhucan123.ons.OnsConfiguration;
import io.gitee.zhucan123.ons.PropertyResolver;
import io.gitee.zhucan123.ons.RocketProperties;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultProducerProxy {
    @Autowired
    protected RocketProperties configuration;
    @Autowired
    private PropertyResolver propertyResolver;
    protected Producer producer;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void setup() {
        if (this.onsConfiguration() == null || !"on".equalsIgnoreCase(this.onsConfiguration().enable())) {
            this.logger.warn("\u914d\u7f6e\u5f00\u5173\u5df2\u5173\u95ed!");
            return;
        }
        Properties properties = this.configuration.rocketProperties();
        properties.put("GROUP_ID", this.propertyResolver.springElResolver(this.onsConfiguration().group()));
        this.producer = ONSFactory.createProducer((Properties)properties);
        this.logger.info("\u542f\u52a8 producer :-> {}", properties.get("GROUP_ID"));
        this.producer.start();
    }

    public <T> SendResult sendMsg(T msg, String tag) {
        this.printLog(msg);
        return this.producer.send(new Message(this.getTopic(), tag, this.toByte(msg)));
    }

    public <T> SendResult sendMsg(T msg, String tag, String key) {
        this.printLog(msg);
        return this.producer.send(new Message(this.getTopic(), tag, key, this.toByte(msg)));
    }

    public <T> SendResult sendMsg(T msg, String tag, String key, String topic) {
        this.printLog(msg);
        return this.producer.send(new Message(topic, tag, key, this.toByte(msg)));
    }

    public SendResult sendMsg(Message message) {
        return this.producer.send(message);
    }

    public String getTopic() {
        if (this.onsConfiguration() != null) {
            return this.propertyResolver.springElResolver(this.onsConfiguration().topic());
        }
        return this.configuration.getTopic();
    }

    protected byte[] toByte(Object o) {
        return JSON.toJSONString((Object)o).getBytes();
    }

    private <T> void printLog(T msg) {
        this.logger.info(" {} \u751f\u4ea7\u8005\u53d1\u9001\u6d88\u606f:{} ", (Object)this.getClass().getSimpleName(), msg);
    }

    protected OnsConfiguration onsConfiguration() {
        return this.getClass().getAnnotation(OnsConfiguration.class);
    }
}

