/*
 * Decompiled with CFR 0.152.
 */
package io.gitee.zhucan123.ons;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import io.gitee.zhucan123.ons.OnsConfiguration;
import io.gitee.zhucan123.ons.PropertyResolver;
import io.gitee.zhucan123.ons.RocketProperties;
import io.gitee.zhucan123.ons.consumer.ConsumerListener;
import io.gitee.zhucan123.ons.consumer.RocketListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;

public class ConsumerAutoRegister {
    @Autowired
    private RocketProperties configuration;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private PropertyResolver propertyResolver;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @PostConstruct
    public void consumerListenerRegister() {
        AutowireCapableBeanFactory autowireCapableBeanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        String[] beanNamesForAnnotation = this.applicationContext.getBeanNamesForAnnotation(ConsumerListener.class);
        final ArrayList rocketListeners = new ArrayList();
        Arrays.stream(beanNamesForAnnotation).map(x -> (RocketListener)autowireCapableBeanFactory.getBean(x)).forEach(x -> {
            ConsumerListener consumerListener = x.getClass().getAnnotation(ConsumerListener.class);
            OnsConfiguration config = x.getClass().getAnnotation(OnsConfiguration.class);
            if ("on".equalsIgnoreCase(config.enable())) {
                for (int i = 0; i < consumerListener.consumers(); ++i) {
                    rocketListeners.add(x);
                }
            }
        });
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                ConsumerAutoRegister.this.listenerRegister(rocketListeners.toArray(new RocketListener[0]));
            }
        }, this.configuration.getDelay());
    }

    private void listenerRegister(RocketListener<?> ... listener) {
        Arrays.stream(listener).forEach(x -> {
            Properties properties = this.configuration.rocketProperties();
            ConsumerListener consumerListener = x.getClass().getAnnotation(ConsumerListener.class);
            OnsConfiguration config = x.getClass().getAnnotation(OnsConfiguration.class);
            properties.put("GROUP_ID", this.propertyResolver.springElResolver(config.group()));
            properties.put("MessageModel", this.propertyResolver.springElResolver(consumerListener.pattern()));
            Consumer consumer = ONSFactory.createConsumer((Properties)properties);
            consumer.subscribe(this.propertyResolver.springElResolver(config.topic()), String.join((CharSequence)"||", consumerListener.tags()), (MessageListener)x);
            this.logger.info("\u542f\u52a8\u6d88\u8d39\u8005: {}", properties.get("GROUP_ID"));
            consumer.start();
        });
    }
}

