/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.jwt;

import cn.hutool.core.util.StrUtil;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.zero.utils.CustomJwtException;
import com.zero.utils.PublicResult;
import com.zero.utils.config.RedisUtil;
import com.zero.utils.config.Utils;
import com.zero.utils.enums.JwtEnums;
import com.zero.utils.enums.LoginRedisEnums;
import com.zero.utils.enums.ResultEnums;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.DigestUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class JwtUtil {
    private static final Logger log = LogManager.getLogger(JwtUtil.class);

    public static String getToken() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!Objects.isNull(requestAttributes)) {
            HttpServletRequest request = ((ServletRequestAttributes)requestAttributes).getRequest();
            String token = request.getHeader(JwtEnums.ACCESS_TOKEN_NAME.getValue());
            if (null == token) {
                token = request.getParameter(JwtEnums.ACCESS_TOKEN_NAME.getValue());
            }
            return token;
        }
        return null;
    }

    static boolean verify(String token) {
        try {
            String secret = JwtUtil.getClaim(token, JwtEnums.MAME.getValue()) + DigestUtils.md5DigestAsHex((byte[])JwtEnums.SECRET_KEY.getValue().getBytes());
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            verifier.verify(token);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getClaim(String token, String claim) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim(claim).asString();
        }
        catch (Exception e) {
            throw new CustomJwtException(PublicResult.resultEnums(ResultEnums.TOKEN_ANALYSIS_0, e.getMessage()));
        }
    }

    public static String getClaim(String claim) {
        String token = JwtUtil.getToken();
        return StrUtil.isBlank((CharSequence)token) ? null : JwtUtil.getClaim(JwtUtil.getToken(), claim);
    }

    public static String buildTokenInfo(String username) {
        String nowStr = String.valueOf(System.currentTimeMillis());
        RedisUtil.set(String.format(LoginRedisEnums.REFRESH_ACCESS_TOKEN_PREFIX.getValue(), username), nowStr);
        HashMap<String, String> map = new HashMap<String, String>(3);
        String realIp = Utils.getRealIp();
        map.put(JwtEnums.MAME.getValue(), username);
        map.put(JwtEnums.CURRENT_TIME_MILLIS.getValue(), nowStr);
        map.put(JwtEnums.IP.getValue(), realIp);
        return JwtUtil.sign(map);
    }

    private static String sign(Map<String, String> map) {
        try {
            String secret = map.get(JwtEnums.MAME.getValue()) + DigestUtils.md5DigestAsHex((byte[])JwtEnums.SECRET_KEY.getValue().getBytes());
            Date date = new Date(System.currentTimeMillis() + (long)(JwtEnums.JWT_EXPIRE_TIME.getIntKey() * 1000));
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTCreator.Builder builder = JWT.create();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                builder.withClaim(entry.getKey(), entry.getValue());
            }
            return builder.withExpiresAt(date).sign(algorithm);
        }
        catch (Exception e) {
            throw new CustomJwtException(PublicResult.resultEnums(ResultEnums.TOKEN_ENCRYPTION_0, e.getMessage()));
        }
    }
}

