/*
 * Decompiled with CFR 0.152.
 */
package com.zero.utils.jwt;

import cn.hutool.core.util.StrUtil;
import com.zero.utils.CustomJwtException;
import com.zero.utils.GsonUtil;
import com.zero.utils.PublicResult;
import com.zero.utils.config.RedisUtil;
import com.zero.utils.enums.JwtEnums;
import com.zero.utils.enums.LoginRedisEnums;
import com.zero.utils.enums.ResultEnums;
import com.zero.utils.jwt.JwtToken;
import com.zero.utils.jwt.JwtUtil;
import java.io.PrintWriter;
import java.util.Objects;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.BasicHttpAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

public class JwtFilter
extends BasicHttpAuthenticationFilter {
    private static final Logger log = LogManager.getLogger(JwtFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginAttempt(request, response)) {
            try {
                boolean verify = JwtUtil.verify(this.getAuthzHeader(request));
                if (!verify) {
                    if (this.refreshToken(request, response)) {
                        return true;
                    }
                    this.response401(response, PublicResult.resultEnums(ResultEnums.TOKEN_INVALID_0));
                    return false;
                }
                this.executeLogin(request, response);
            }
            catch (Exception e) {
                PublicResult result = PublicResult.resultEnums(ResultEnums.TOKEN_AUTHENTICATION_0, e.getMessage());
                if (e instanceof CustomJwtException) {
                    result = GsonUtil.gsonToBean(e.getMessage(), PublicResult.class);
                }
                this.response401(response, result);
                return false;
            }
        } else {
            this.response401(response, PublicResult.resultEnums(ResultEnums.UN_LOGIN_0));
            return false;
        }
        return true;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        this.sendChallenge(request, response);
        return false;
    }

    protected boolean isLoginAttempt(ServletRequest request, ServletResponse response) {
        return StrUtil.isNotBlank((CharSequence)this.getAuthzHeader(request));
    }

    protected String getAuthzHeader(ServletRequest request) {
        String token = super.getAuthzHeader(request);
        if (null == token) {
            token = request.getParameter(JwtEnums.ACCESS_TOKEN_NAME.getValue());
        }
        return token;
    }

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws Exception {
        JwtToken token = new JwtToken(this.getAuthzHeader(request));
        this.getSubject(request, response).login((AuthenticationToken)token);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshToken(ServletRequest request, ServletResponse response) {
        String token = this.getAuthzHeader(request);
        String username = JwtUtil.getClaim(token, JwtEnums.MAME.getValue());
        String refreshTokenTime = RedisUtil.getStr(String.format(LoginRedisEnums.REFRESH_ACCESS_TOKEN_PREFIX.getValue(), username));
        String claim = JwtUtil.getClaim(token, JwtEnums.CURRENT_TIME_MILLIS.getValue());
        JwtFilter jwtFilter = this;
        synchronized (jwtFilter) {
            if (Objects.equals(refreshTokenTime, claim) && Objects.equals(token, RedisUtil.getStr(String.format(LoginRedisEnums.ACCESS_TOKEN_PREFIX.getValue(), username)))) {
                String nowToken = JwtUtil.buildTokenInfo(username);
                String format = String.format(LoginRedisEnums.ACCESS_TOKEN_PREFIX.getValue(), username);
                RedisUtil.setExSeconds(String.format(LoginRedisEnums.CACHE_TOKEN_PREFIX.getValue(), username), token, JwtEnums.CACHE_TOKEN_EXPIRE_TIME.getIntKey());
                RedisUtil.setExSeconds(format, nowToken, JwtEnums.REDIS_EXPIRE_TIME.getIntKey());
                JwtToken jwtToken = new JwtToken(nowToken);
                this.getSubject(request, response).login((AuthenticationToken)jwtToken);
                HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
                httpServletResponse.setHeader(JwtEnums.ACCESS_TOKEN_NAME.getValue(), nowToken);
                httpServletResponse.setHeader("Access-Control-Expose-Headers", JwtEnums.ACCESS_TOKEN_NAME.getValue());
                log.info("\u5237\u65b0token");
                return true;
            }
            String str = RedisUtil.getStr(String.format(LoginRedisEnums.CACHE_TOKEN_PREFIX.getValue(), username));
            if (Objects.equals(str, token)) {
                JwtToken jwtToken = new JwtToken(RedisUtil.getStr(String.format(LoginRedisEnums.ACCESS_TOKEN_PREFIX.getValue(), username)));
                this.getSubject(request, response).login((AuthenticationToken)jwtToken);
                log.info("\u4f7f\u7528\u7f13\u5b58token");
                return true;
            }
            return false;
        }
    }

    private void response401(ServletResponse response, PublicResult result) {
        HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
        httpServletResponse.setStatus(ResultEnums.UNAUTHORIZED.getKey());
        httpServletResponse.setCharacterEncoding("UTF-8");
        httpServletResponse.setContentType("application/json; charset=utf-8");
        try (PrintWriter out = httpServletResponse.getWriter();){
            out.append(GsonUtil.toJson(result));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

